/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.springframework.binding.message.Message;
import org.springframework.binding.message.MessageCriteria;
import org.springframework.binding.message.MessageResolver;
import org.springframework.binding.message.Severity;
import org.springframework.context.MessageSource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.StringUtils;
import org.springframework.webflow.execution.RequestContext;

public class FlowFacesContextMessageDelegate {
    private RequestContext context;
    static final String SUMMARY_MESSAGE_KEY = "_summary";
    static final String DETAIL_MESSAGE_KEY = "_detail";
    private static final Map FACESSEVERITY_TO_SPRINGSEVERITY = new HashMap();

    static {
        FACESSEVERITY_TO_SPRINGSEVERITY.put(FacesMessage.SEVERITY_INFO, Severity.INFO);
        FACESSEVERITY_TO_SPRINGSEVERITY.put(FacesMessage.SEVERITY_WARN, Severity.WARNING);
        FACESSEVERITY_TO_SPRINGSEVERITY.put(FacesMessage.SEVERITY_ERROR, Severity.ERROR);
    }

    public FlowFacesContextMessageDelegate(RequestContext context) {
        this.context = context;
    }

    public void addMessage(String clientId, FacesMessage message) {
        String source = null;
        if (StringUtils.hasText((String)clientId)) {
            source = clientId;
        }
        this.context.getMessageContext().addMessage((MessageResolver)new FlowFacesMessageAdapter(source, SUMMARY_MESSAGE_KEY, message));
        this.context.getMessageContext().addMessage((MessageResolver)new FlowFacesMessageAdapter(source, DETAIL_MESSAGE_KEY, message));
    }

    public Iterator getClientIdsWithMessages() {
        return new ClientIdIterator();
    }

    public FacesMessage.Severity getMaximumSeverity() {
        if (this.context.getMessageContext().getAllMessages().length == 0) {
            return null;
        }
        FacesMessage.Severity max = FacesMessage.SEVERITY_INFO;
        Iterator i = this.getMessages();
        while (i.hasNext()) {
            FacesMessage message = (FacesMessage)i.next();
            if (message.getSeverity().getOrdinal() > max.getOrdinal()) {
                max = message.getSeverity();
            }
            if (max.getOrdinal() == FacesMessage.SEVERITY_FATAL.getOrdinal()) break;
        }
        return max;
    }

    public Iterator getMessages() {
        return new FacesMessageIterator();
    }

    public Iterator getMessages(String clientId) {
        return new FacesMessageIterator(clientId);
    }

    private FacesMessage toFacesMessage(Message summaryMessage, Message detailMessage) {
        if (summaryMessage instanceof FlowFacesMessageAdapter) {
            return ((FlowFacesMessageAdapter)summaryMessage).getFacesMessage();
        }
        if (detailMessage instanceof FlowFacesMessageAdapter) {
            return ((FlowFacesMessageAdapter)detailMessage).getFacesMessage();
        }
        if (summaryMessage.getSeverity() == Severity.INFO) {
            return new FacesMessage(FacesMessage.SEVERITY_INFO, summaryMessage.getText(), detailMessage.getText());
        }
        if (summaryMessage.getSeverity() == Severity.WARNING) {
            return new FacesMessage(FacesMessage.SEVERITY_WARN, summaryMessage.getText(), detailMessage.getText());
        }
        if (summaryMessage.getSeverity() == Severity.ERROR) {
            return new FacesMessage(FacesMessage.SEVERITY_ERROR, summaryMessage.getText(), detailMessage.getText());
        }
        return new FacesMessage(FacesMessage.SEVERITY_FATAL, summaryMessage.getText(), detailMessage.getText());
    }

    private class ClientIdIterator
    implements Iterator {
        private Message[] messages;
        int currentIndex = -1;

        protected ClientIdIterator() {
            this.messages = FlowFacesContextMessageDelegate.this.context.getMessageContext().getMessagesByCriteria((MessageCriteria)new IdentifiedMessageCriteria());
        }

        public boolean hasNext() {
            return this.messages.length > this.currentIndex + 1;
        }

        public Object next() {
            Message next;
            if ((next = this.messages[++this.currentIndex]).getSource() == null) {
                return null;
            }
            if (next.getSource().toString().endsWith(FlowFacesContextMessageDelegate.SUMMARY_MESSAGE_KEY)) {
                return next.getSource().toString().replaceAll(FlowFacesContextMessageDelegate.SUMMARY_MESSAGE_KEY, "");
            }
            return next.getSource().toString();
        }

        public void remove() {
            throw new UnsupportedOperationException("Messages cannot be removed through this iterator.");
        }
    }

    private class DetailMessageCriteria
    implements MessageCriteria {
        private DetailMessageCriteria() {
        }

        public boolean test(Message message) {
            if (message.getSource() == null) {
                return false;
            }
            return message.getSource().toString().endsWith(FlowFacesContextMessageDelegate.DETAIL_MESSAGE_KEY);
        }
    }

    private class FacesMessageIterator
    implements Iterator {
        private Object[] messages;
        private int currentIndex = -1;

        protected FacesMessageIterator() {
            Message[] summaryMessages = FlowFacesContextMessageDelegate.this.context.getMessageContext().getMessagesByCriteria((MessageCriteria)new SummaryMessageCriteria());
            Message[] detailMessages = FlowFacesContextMessageDelegate.this.context.getMessageContext().getMessagesByCriteria((MessageCriteria)new DetailMessageCriteria());
            Message[] userMessages = FlowFacesContextMessageDelegate.this.context.getMessageContext().getMessagesByCriteria((MessageCriteria)new UserMessageCriteria());
            ArrayList<FacesMessage> translatedMessages = new ArrayList<FacesMessage>();
            int i = 0;
            while (i < summaryMessages.length) {
                translatedMessages.add(FlowFacesContextMessageDelegate.this.toFacesMessage(summaryMessages[i], detailMessages[i]));
                ++i;
            }
            int z = 0;
            while (z < userMessages.length) {
                translatedMessages.add(FlowFacesContextMessageDelegate.this.toFacesMessage(userMessages[z], userMessages[z]));
                ++z;
            }
            this.messages = translatedMessages.toArray();
        }

        protected FacesMessageIterator(String clientId) {
            Message[] summaryMessages = FlowFacesContextMessageDelegate.this.context.getMessageContext().getMessagesBySource((Object)(String.valueOf(clientId) + FlowFacesContextMessageDelegate.SUMMARY_MESSAGE_KEY));
            Message[] detailMessages = FlowFacesContextMessageDelegate.this.context.getMessageContext().getMessagesBySource((Object)(String.valueOf(clientId) + FlowFacesContextMessageDelegate.DETAIL_MESSAGE_KEY));
            Message[] userMessages = FlowFacesContextMessageDelegate.this.context.getMessageContext().getMessagesBySource((Object)clientId);
            ArrayList<FacesMessage> translatedMessages = new ArrayList<FacesMessage>();
            int i = 0;
            while (i < summaryMessages.length) {
                translatedMessages.add(FlowFacesContextMessageDelegate.this.toFacesMessage(summaryMessages[i], detailMessages[i]));
                ++i;
            }
            int z = 0;
            while (z < userMessages.length) {
                translatedMessages.add(FlowFacesContextMessageDelegate.this.toFacesMessage(userMessages[z], userMessages[z]));
                ++z;
            }
            this.messages = translatedMessages.toArray();
        }

        public boolean hasNext() {
            return this.messages.length > this.currentIndex + 1;
        }

        public Object next() {
            ++this.currentIndex;
            return this.messages[this.currentIndex];
        }

        public void remove() {
            throw new UnsupportedOperationException("Messages cannot be removed through this iterator.");
        }
    }

    private static class FlowFacesMessageAdapter
    extends Message
    implements MessageResolver {
        private String key;
        private FacesMessage facesMessage;
        private String source;

        public FlowFacesMessageAdapter(String source, String key, FacesMessage message) {
            super(null, null, null);
            this.source = source;
            this.key = key;
            this.facesMessage = message;
        }

        public Object getSource() {
            return String.valueOf(this.source) + this.key;
        }

        public String getText() {
            String text = null;
            if (FlowFacesContextMessageDelegate.DETAIL_MESSAGE_KEY.equals(this.key)) {
                text = this.facesMessage.getDetail();
            } else if (FlowFacesContextMessageDelegate.SUMMARY_MESSAGE_KEY.equals(this.key)) {
                text = this.facesMessage.getSummary();
            } else {
                throw new RuntimeException("Unknown faces message type key");
            }
            if (StringUtils.hasText((String)text)) {
                return text;
            }
            return "";
        }

        public Severity getSeverity() {
            Severity severity = null;
            if (this.facesMessage.getSeverity() != null) {
                severity = (Severity)FACESSEVERITY_TO_SPRINGSEVERITY.get(this.facesMessage.getSeverity());
            }
            return severity == null ? Severity.INFO : severity;
        }

        public String toString() {
            ToStringCreator rtn = new ToStringCreator((Object)this);
            rtn.append("severity", (Object)this.getSeverity());
            if (FacesContext.getCurrentInstance() != null) {
                rtn.append("text", (Object)this.getText());
            }
            return rtn.toString();
        }

        public Message resolveMessage(MessageSource messageSource, Locale locale) {
            return this;
        }

        public FacesMessage getFacesMessage() {
            return this.facesMessage;
        }
    }

    private class IdentifiedMessageCriteria
    implements MessageCriteria {
        String nullSummaryId = null + "_summary";
        private Set identifiedMessageSources = new HashSet();

        private IdentifiedMessageCriteria() {
        }

        public boolean test(Message message) {
            if (message.getSource() != null && message.getSource().toString().endsWith(FlowFacesContextMessageDelegate.DETAIL_MESSAGE_KEY)) {
                return false;
            }
            if (message.getSource() == null || message.getSource().equals("") || message.getSource().equals(this.nullSummaryId)) {
                return this.identifiedMessageSources.add(null);
            }
            return this.identifiedMessageSources.add(message.getSource());
        }
    }

    private class SummaryMessageCriteria
    implements MessageCriteria {
        private SummaryMessageCriteria() {
        }

        public boolean test(Message message) {
            if (message.getSource() == null) {
                return false;
            }
            return message.getSource().toString().endsWith(FlowFacesContextMessageDelegate.SUMMARY_MESSAGE_KEY);
        }
    }

    private class UserMessageCriteria
    implements MessageCriteria {
        private UserMessageCriteria() {
        }

        public boolean test(Message message) {
            if (message.getSource() == null) {
                return true;
            }
            return !message.getSource().toString().endsWith(FlowFacesContextMessageDelegate.SUMMARY_MESSAGE_KEY) && !message.getSource().toString().endsWith(FlowFacesContextMessageDelegate.DETAIL_MESSAGE_KEY);
        }
    }
}

