/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.ui.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class ResourceHelper {
    private static final String RENDERED_RESOURCES_KEY = "org.springframework.faces.RenderedResources";
    private static final String COMBINED_RESOURCES_KEY = "org.springframework.faces.CombinedResources";
    private static final String SCRIPT_BLOCK_ESCAPE_BEGIN = "<!--//--><![CDATA[//><!--\n";
    private static final String SCRIPT_BLOCK_ESCAPE_END = "\n//--><!]]>";
    private static final String SCRIPT_ELEMENT = "script";

    private ResourceHelper() {
    }

    public static void renderResource(FacesContext facesContext, String resourcePath) throws IOException {
        if (resourcePath.endsWith(".js")) {
            ResourceHelper.renderScriptLink(facesContext, resourcePath);
        } else if (resourcePath.endsWith(".css")) {
            ResourceHelper.renderStyleLink(facesContext, resourcePath);
        }
    }

    public static void renderScriptLink(FacesContext facesContext, String scriptPath) throws IOException {
        ResourceHelper.renderScriptLink(facesContext, scriptPath, Collections.EMPTY_MAP);
    }

    public static void renderScriptLink(FacesContext facesContext, String scriptPath, Map attributes) throws IOException {
        if (ResourceHelper.alreadyRendered(facesContext, scriptPath)) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement(SCRIPT_ELEMENT, null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            writer.writeAttribute(key, attributes.get(key), null);
        }
        String src = String.valueOf(facesContext.getExternalContext().getRequestContextPath()) + "/resources" + scriptPath;
        writer.writeAttribute("src", (Object)src, null);
        writer.endElement(SCRIPT_ELEMENT);
        ResourceHelper.markRendered(facesContext, scriptPath);
    }

    public static void renderStyleLink(FacesContext facesContext, String cssPath) throws IOException {
        if (ResourceHelper.alreadyRendered(facesContext, cssPath)) {
            return;
        }
        if (ResourceHelper.isCombineStyles(facesContext)) {
            ResourceHelper.addStyle(facesContext, cssPath);
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("link", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        String src = String.valueOf(facesContext.getExternalContext().getRequestContextPath()) + "/resources" + cssPath;
        writer.writeAttribute("href", (Object)src, null);
        writer.endElement("link");
        ResourceHelper.markRendered(facesContext, cssPath);
    }

    public static void renderDojoInclude(FacesContext facesContext, String module) throws IOException {
        if (ResourceHelper.alreadyRendered(facesContext, module)) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement(SCRIPT_ELEMENT, null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)("dojo.require('" + module + "');"), null);
        writer.endElement(SCRIPT_ELEMENT);
        ResourceHelper.markRendered(facesContext, module);
    }

    public static void beginCombineStyles(FacesContext facesContext) {
        ArrayList combinedResources = new ArrayList();
        facesContext.getExternalContext().getRequestMap().put(COMBINED_RESOURCES_KEY, combinedResources);
    }

    private static boolean isCombineStyles(FacesContext facesContext) {
        return facesContext.getExternalContext().getRequestMap().containsKey(COMBINED_RESOURCES_KEY);
    }

    private static void addStyle(FacesContext facesContext, String stylePath) {
        List combinedResources = (List)facesContext.getExternalContext().getRequestMap().get(COMBINED_RESOURCES_KEY);
        combinedResources.add(stylePath);
    }

    public static void endCombineStyles(FacesContext facesContext) throws IOException {
        List combinedResources = (List)facesContext.getExternalContext().getRequestMap().remove(COMBINED_RESOURCES_KEY);
        StringBuffer combinedPath = new StringBuffer();
        int i = 0;
        while (i < combinedResources.size()) {
            String resourcePath = (String)combinedResources.get(i);
            if (i == 1) {
                combinedPath.append("?appended=");
            }
            if (i > 1) {
                combinedPath.append(",");
            }
            combinedPath.append(resourcePath);
            ++i;
        }
        ResourceHelper.renderStyleLink(facesContext, combinedPath.toString());
    }

    public static void beginScriptBlock(FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement(SCRIPT_ELEMENT, null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)SCRIPT_BLOCK_ESCAPE_BEGIN, null);
    }

    public static void endScriptBlock(FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.writeText((Object)SCRIPT_BLOCK_ESCAPE_END, null);
        writer.endElement(SCRIPT_ELEMENT);
    }

    private static void markRendered(FacesContext facesContext, String scriptPath) {
        HashSet<String> renderedResources = (HashSet<String>)facesContext.getExternalContext().getRequestMap().get(RENDERED_RESOURCES_KEY);
        if (renderedResources == null) {
            renderedResources = new HashSet<String>();
            facesContext.getExternalContext().getRequestMap().put(RENDERED_RESOURCES_KEY, renderedResources);
        }
        renderedResources.add(scriptPath);
    }

    private static boolean alreadyRendered(FacesContext facesContext, String scriptPath) {
        Set renderedResources = (Set)facesContext.getExternalContext().getRequestMap().get(RENDERED_RESOURCES_KEY);
        return renderedResources != null && renderedResources.contains(scriptPath);
    }
}

