/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import java.util.Collection;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.core.CollectionFactory;
import org.springframework.core.GenericCollectionTypeResolver;

public class CollectionToCollection
implements Converter {
    private static final int DEFAULT_INITIAL_SIZE = 16;
    private ConversionService conversionService;
    private ConversionExecutor elementConverter;

    public CollectionToCollection(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public CollectionToCollection(ConversionExecutor elementConverter) {
        this.elementConverter = elementConverter;
    }

    @Override
    public Class<?> getSourceClass() {
        return Collection.class;
    }

    @Override
    public Class<?> getTargetClass() {
        return Collection.class;
    }

    @Override
    public Object convertSourceToTargetClass(Object source, Class<?> targetClass) throws Exception {
        if (source == null) {
            return null;
        }
        Collection targetCollection = CollectionFactory.createCollection(targetClass, (int)16);
        ConversionExecutor elementConverter = this.getElementConverter(source, targetClass);
        Collection sourceCollection = (Collection)source;
        for (Object value : sourceCollection) {
            if (elementConverter != null) {
                value = elementConverter.execute(value);
            }
            targetCollection.add(value);
        }
        return targetCollection;
    }

    private ConversionExecutor getElementConverter(Object source, Class<? extends Collection<?>> targetClass) {
        if (this.elementConverter != null) {
            return this.elementConverter;
        }
        Class elementType = GenericCollectionTypeResolver.getCollectionType(targetClass);
        if (elementType != null) {
            Class<?> componentType = source.getClass().getComponentType();
            return this.conversionService.getConversionExecutor(componentType, elementType);
        }
        return null;
    }
}

