/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.service;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.binding.convert.ConversionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionExecutorNotFoundException;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.converters.ArrayToArray;
import org.springframework.binding.convert.converters.ArrayToCollection;
import org.springframework.binding.convert.converters.CollectionToCollection;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.binding.convert.converters.ObjectToArray;
import org.springframework.binding.convert.converters.ObjectToCollection;
import org.springframework.binding.convert.converters.ReverseConverter;
import org.springframework.binding.convert.converters.SpringConvertingConverterAdapter;
import org.springframework.binding.convert.converters.TwoWayConverter;
import org.springframework.binding.convert.service.NoOpConverter;
import org.springframework.binding.convert.service.SpringBindingConverterAdapter;
import org.springframework.binding.convert.service.StaticConversionExecutor;
import org.springframework.binding.convert.service.TwoWayCapableConversionExecutor;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.support.FormattingConversionServiceFactoryBean;
import org.springframework.util.Assert;

public class GenericConversionService
implements ConversionService {
    private org.springframework.core.convert.ConversionService delegate;
    private final Map<String, Converter> customConverters = new HashMap<String, Converter>();
    private final Map<String, Class<?>> aliasMap = new HashMap();
    private ConversionService parent;

    public GenericConversionService() {
        FormattingConversionServiceFactoryBean factoryBean = new FormattingConversionServiceFactoryBean();
        factoryBean.afterPropertiesSet();
        this.delegate = factoryBean.getObject();
    }

    public GenericConversionService(org.springframework.core.convert.ConversionService delegateConversionService) {
        Assert.notNull((Object)delegateConversionService);
        this.delegate = delegateConversionService;
    }

    public ConversionService getParent() {
        return this.parent;
    }

    public void setParent(ConversionService parent) {
        this.parent = parent;
    }

    @Override
    public org.springframework.core.convert.ConversionService getDelegateConversionService() {
        return this.delegate;
    }

    public void addConverter(Converter converter) {
        ((ConverterRegistry)this.delegate).addConverter((GenericConverter)new SpringBindingConverterAdapter(converter));
        if (converter instanceof TwoWayConverter) {
            TwoWayConverter twoWayConverter = (TwoWayConverter)converter;
            ((ConverterRegistry)this.delegate).addConverter((GenericConverter)new SpringBindingConverterAdapter(new ReverseConverter(twoWayConverter)));
        }
    }

    public void addConverter(String id, Converter converter) {
        this.customConverters.put(id, converter);
    }

    public void addAlias(String alias, Class<?> targetType) {
        this.aliasMap.put(alias, targetType);
    }

    @Override
    public ConversionExecutor getConversionExecutor(Class<?> sourceClass, Class<?> targetClass) throws ConversionExecutorNotFoundException {
        Assert.notNull(sourceClass, (String)"The source class to convert from is required");
        Assert.notNull(targetClass, (String)"The target class to convert to is required");
        sourceClass = this.convertToWrapperClassIfNecessary(sourceClass);
        targetClass = this.convertToWrapperClassIfNecessary(targetClass);
        if (targetClass.isAssignableFrom(sourceClass)) {
            return new StaticConversionExecutor(sourceClass, targetClass, new NoOpConverter(sourceClass, targetClass));
        }
        if (this.delegate.canConvert(sourceClass, targetClass)) {
            return new StaticConversionExecutor(sourceClass, targetClass, new SpringConvertingConverterAdapter(sourceClass, targetClass, this.delegate));
        }
        if (this.parent != null) {
            return this.parent.getConversionExecutor(sourceClass, targetClass);
        }
        throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "No ConversionExecutor found for converting from sourceClass [" + sourceClass.getName() + "] to target class [" + targetClass.getName() + "]");
    }

    @Override
    public ConversionExecutor getConversionExecutor(String id, Class<?> sourceClass, Class<?> targetClass) throws ConversionExecutorNotFoundException {
        Assert.hasText((String)id, (String)"The id of the custom converter is required");
        Assert.notNull(sourceClass, (String)"The source class to convert from is required");
        Assert.notNull(targetClass, (String)"The target class to convert to is required");
        Converter converter = this.customConverters.get(id);
        if (converter == null) {
            if (this.parent != null) {
                return this.parent.getConversionExecutor(id, sourceClass, targetClass);
            }
            throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "No custom ConversionExecutor found with id '" + id + "' for converting from sourceClass [" + sourceClass.getName() + "] to targetClass [" + targetClass.getName() + "]");
        }
        sourceClass = this.convertToWrapperClassIfNecessary(sourceClass);
        targetClass = this.convertToWrapperClassIfNecessary(targetClass);
        if (sourceClass.isArray()) {
            Class<?> sourceComponentType = sourceClass.getComponentType();
            if (targetClass.isArray()) {
                Class<?> targetComponentType = targetClass.getComponentType();
                if (converter.getSourceClass().isAssignableFrom(sourceComponentType)) {
                    if (!converter.getTargetClass().isAssignableFrom(targetComponentType)) {
                        throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from an array storing elements of type [" + sourceComponentType.getName() + "] to an array of storing elements of type [" + targetComponentType.getName() + "]");
                    }
                    StaticConversionExecutor elementConverter = new StaticConversionExecutor(sourceComponentType, targetComponentType, converter);
                    return new StaticConversionExecutor(sourceClass, targetClass, new ArrayToArray(elementConverter));
                }
                if (converter.getTargetClass().isAssignableFrom(sourceComponentType) && converter instanceof TwoWayConverter) {
                    TwoWayConverter twoWay = (TwoWayConverter)converter;
                    StaticConversionExecutor elementConverter = new StaticConversionExecutor(sourceComponentType, targetComponentType, new ReverseConverter(twoWay));
                    return new StaticConversionExecutor(sourceClass, targetClass, new ArrayToArray(elementConverter));
                }
                throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from an array storing elements of type [" + sourceComponentType.getName() + "] to an array storing elements of type [" + targetComponentType.getName() + "]");
            }
            if (Collection.class.isAssignableFrom(targetClass)) {
                if (!targetClass.isInterface() && Modifier.isAbstract(targetClass.getModifiers())) {
                    throw new IllegalArgumentException("Conversion target class [" + targetClass.getName() + "] is invalid; cannot convert to abstract collection types--" + "request an interface or concrete implementation instead");
                }
                if (converter.getSourceClass().isAssignableFrom(sourceComponentType)) {
                    StaticConversionExecutor elementConverter = new StaticConversionExecutor(sourceComponentType, converter.getTargetClass(), converter);
                    return new StaticConversionExecutor(sourceClass, targetClass, new ArrayToCollection(elementConverter));
                }
                if (converter.getTargetClass().isAssignableFrom(sourceComponentType) && converter instanceof TwoWayConverter) {
                    TwoWayConverter twoWay = (TwoWayConverter)converter;
                    StaticConversionExecutor elementConverter = new StaticConversionExecutor(sourceComponentType, converter.getSourceClass(), new ReverseConverter(twoWay));
                    return new StaticConversionExecutor(sourceClass, targetClass, new ArrayToCollection(elementConverter));
                }
                throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from array an storing elements type [" + sourceComponentType.getName() + "] to a collection of type [" + targetClass.getName() + "]");
            }
        }
        if (targetClass.isArray()) {
            Class<?> targetComponentType = targetClass.getComponentType();
            if (Collection.class.isAssignableFrom(sourceClass)) {
                if (converter.getTargetClass().isAssignableFrom(targetComponentType)) {
                    StaticConversionExecutor elementConverter = new StaticConversionExecutor(converter.getSourceClass(), targetComponentType, converter);
                    ReverseConverter collectionToArray = new ReverseConverter(new ArrayToCollection(elementConverter));
                    return new StaticConversionExecutor(sourceClass, targetClass, collectionToArray);
                }
                if (converter.getSourceClass().isAssignableFrom(targetComponentType) && converter instanceof TwoWayConverter) {
                    TwoWayConverter twoWay = (TwoWayConverter)converter;
                    StaticConversionExecutor elementConverter = new StaticConversionExecutor(converter.getTargetClass(), targetComponentType, new ReverseConverter(twoWay));
                    ReverseConverter collectionToArray = new ReverseConverter(new ArrayToCollection(elementConverter));
                    return new StaticConversionExecutor(sourceClass, targetClass, collectionToArray);
                }
                throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from collection of type [" + sourceClass.getName() + "] to an array storing elements of type [" + targetComponentType.getName() + "]");
            }
            if (converter.getSourceClass().isAssignableFrom(sourceClass)) {
                if (!converter.getTargetClass().isAssignableFrom(targetComponentType)) {
                    throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from sourceClass [" + sourceClass.getName() + "] to array holding elements of type [" + targetComponentType.getName() + "]");
                }
                StaticConversionExecutor elementConverter = new StaticConversionExecutor(sourceClass, targetComponentType, converter);
                return new StaticConversionExecutor(sourceClass, targetClass, new ObjectToArray(elementConverter));
            }
            if (converter.getTargetClass().isAssignableFrom(sourceClass) && converter instanceof TwoWayConverter) {
                if (!converter.getSourceClass().isAssignableFrom(targetComponentType)) {
                    throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from sourceClass [" + sourceClass.getName() + "] to array holding elements of type [" + targetComponentType.getName() + "]");
                }
                TwoWayConverter twoWay = (TwoWayConverter)converter;
                StaticConversionExecutor elementConverter = new StaticConversionExecutor(sourceClass, targetComponentType, new ReverseConverter(twoWay));
                return new StaticConversionExecutor(sourceClass, targetClass, new ObjectToArray(elementConverter));
            }
        }
        if (Collection.class.isAssignableFrom(targetClass)) {
            ConversionExecutor elementConverter;
            if (Collection.class.isAssignableFrom(sourceClass)) {
                elementConverter = converter instanceof TwoWayConverter ? new TwoWayCapableConversionExecutor(converter.getSourceClass(), converter.getTargetClass(), (TwoWayConverter)converter) : new StaticConversionExecutor(converter.getSourceClass(), converter.getTargetClass(), converter);
                return new StaticConversionExecutor(sourceClass, targetClass, new CollectionToCollection(elementConverter));
            }
            elementConverter = converter instanceof TwoWayConverter ? new TwoWayCapableConversionExecutor(sourceClass, converter.getTargetClass(), (TwoWayConverter)converter) : new StaticConversionExecutor(sourceClass, converter.getTargetClass(), converter);
            if (!Collection.class.isAssignableFrom(converter.getTargetClass())) {
                elementConverter = new StaticConversionExecutor(sourceClass, targetClass, new ObjectToCollection(elementConverter));
            }
            return elementConverter;
        }
        if (converter.getSourceClass().isAssignableFrom(sourceClass)) {
            if (!converter.getTargetClass().isAssignableFrom(targetClass)) {
                throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from sourceClass [" + sourceClass.getName() + "] to targetClass [" + targetClass.getName() + "]");
            }
            return new StaticConversionExecutor(sourceClass, targetClass, converter);
        }
        if (converter.getTargetClass().isAssignableFrom(sourceClass) && converter instanceof TwoWayConverter) {
            if (!converter.getSourceClass().isAssignableFrom(targetClass)) {
                throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from sourceClass [" + sourceClass.getName() + "] to targetClass [" + targetClass.getName() + "]");
            }
            TwoWayConverter twoWay = (TwoWayConverter)converter;
            return new StaticConversionExecutor(sourceClass, targetClass, new ReverseConverter(twoWay));
        }
        throw new ConversionExecutorNotFoundException(sourceClass, targetClass, "Custom ConversionExecutor with id '" + id + "' cannot convert from sourceClass [" + sourceClass.getName() + "] to targetClass [" + targetClass.getName() + "]");
    }

    @Override
    public Object executeConversion(Object source, Class<?> targetClass) throws ConversionException {
        if (source != null) {
            ConversionExecutor conversionExecutor = this.getConversionExecutor(source.getClass(), targetClass);
            return conversionExecutor.execute(source);
        }
        return null;
    }

    @Override
    public Object executeConversion(String converterId, Object source, Class<?> targetClass) throws ConversionException {
        if (source != null) {
            ConversionExecutor conversionExecutor = this.getConversionExecutor(converterId, source.getClass(), targetClass);
            return conversionExecutor.execute(source);
        }
        return null;
    }

    @Override
    public Class<?> getClassForAlias(String name) throws IllegalArgumentException {
        Class<?> clazz = this.aliasMap.get(name);
        if (clazz != null) {
            return clazz;
        }
        if (this.parent != null) {
            return this.parent.getClassForAlias(name);
        }
        return null;
    }

    private Class<?> convertToWrapperClassIfNecessary(Class<?> targetType) {
        if (targetType.isPrimitive()) {
            if (targetType.equals(Integer.TYPE)) {
                return Integer.class;
            }
            if (targetType.equals(Short.TYPE)) {
                return Short.class;
            }
            if (targetType.equals(Long.TYPE)) {
                return Long.class;
            }
            if (targetType.equals(Float.TYPE)) {
                return Float.class;
            }
            if (targetType.equals(Double.TYPE)) {
                return Double.class;
            }
            if (targetType.equals(Byte.TYPE)) {
                return Byte.class;
            }
            if (targetType.equals(Boolean.TYPE)) {
                return Boolean.class;
            }
            if (targetType.equals(Character.TYPE)) {
                return Character.class;
            }
            throw new IllegalStateException("Should never happen - primitive type is not a primitive?");
        }
        return targetType;
    }
}

