/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.uml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.uml2.uml.Model;
import org.springframework.core.io.Resource;
import org.springframework.statemachine.config.model.AbstractStateMachineModelFactory;
import org.springframework.statemachine.config.model.ConfigurationData;
import org.springframework.statemachine.config.model.DefaultStateMachineModel;
import org.springframework.statemachine.config.model.StateMachineComponentResolver;
import org.springframework.statemachine.config.model.StateMachineModel;
import org.springframework.statemachine.config.model.StateMachineModelFactory;
import org.springframework.statemachine.uml.support.UmlModelParser;
import org.springframework.statemachine.uml.support.UmlUtils;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class UmlStateMachineModelFactory
extends AbstractStateMachineModelFactory<String, String>
implements StateMachineModelFactory<String, String> {
    private Resource resource;
    private String location;

    public UmlStateMachineModelFactory(Resource resource) {
        Assert.notNull((Object)resource, (String)"Resource must be set");
        this.resource = resource;
    }

    public UmlStateMachineModelFactory(String location) {
        Assert.notNull((Object)location, (String)"Location must be set");
        this.location = location;
    }

    public StateMachineModel<String, String> build() {
        Model model = null;
        try {
            model = UmlUtils.getModel(this.getResourceUri(this.resolveResource()).getPath());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot build build model from resource " + this.resource + " or location " + this.location, e);
        }
        UmlModelParser parser = new UmlModelParser(model, (StateMachineComponentResolver<String, String>)this);
        UmlModelParser.DataHolder dataHolder = parser.parseModel();
        ConfigurationData configurationData = new ConfigurationData();
        return new DefaultStateMachineModel(configurationData, dataHolder.getStatesData(), dataHolder.getTransitionsData());
    }

    private Resource resolveResource() {
        if (this.resource != null) {
            return this.resource;
        }
        return this.getResourceLoader().getResource(this.location);
    }

    private URI getResourceUri(Resource resource) throws IOException {
        try {
            return resource.getFile().toURI();
        }
        catch (Exception exception) {
            Path tempFile = Files.createTempFile(null, ".uml", new FileAttribute[0]);
            FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)new FileOutputStream(tempFile.toFile()));
            return tempFile.toUri();
        }
    }
}

