/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.test.StateMachineTestPlan;

public class StateMachineTestPlanBuilder<S, E> {
    private Map<Object, StateMachine<S, E>> stateMachines = new HashMap<Object, StateMachine<S, E>>();
    private final List<StateMachineTestPlanStep<S, E>> steps = new ArrayList<StateMachineTestPlanStep<S, E>>();
    private Integer defaultAwaitTime;

    public static <S, E> StateMachineTestPlanBuilder<S, E> builder() {
        return new StateMachineTestPlanBuilder<S, E>();
    }

    public StateMachineTestPlanBuilder<S, E> stateMachine(StateMachine<S, E> stateMachine) {
        return this.stateMachine(stateMachine, stateMachine);
    }

    public StateMachineTestPlanBuilder<S, E> stateMachine(StateMachine<S, E> stateMachine, Object machineId) {
        this.stateMachines.put(machineId, stateMachine);
        return this;
    }

    public StateMachineTestPlanBuilder<S, E> defaultAwaitTime(int seconds) {
        if (seconds < 0) {
            throw new IllegalArgumentException("Default await time cannot be negative, was " + seconds);
        }
        this.defaultAwaitTime = seconds;
        return this;
    }

    public StateMachineTestPlanStepBuilder step() {
        return new StateMachineTestPlanStepBuilder();
    }

    public StateMachineTestPlan<S, E> build() {
        return new StateMachineTestPlan<S, E>(this.stateMachines, this.steps, this.defaultAwaitTime);
    }

    static class StateMachineTestPlanStep<S, E> {
        final List<E> sendEvent;
        final List<Message<E>> sendMessage;
        Object sendEventMachineId;
        boolean sendEventToAll = false;
        boolean sendEventParallel = false;
        final Collection<S> expectStates;
        final Collection<S> expectStatesEntrered;
        final Collection<S> expectStatesExited;
        Integer expectStateChanged;
        Integer expectStateEntered;
        Integer expectStateExited;
        Integer expectEventNotAccepted;
        Integer expectTransition;
        Integer expectTransitionStarted;
        Integer expectTransitionEnded;
        Integer expectStateMachineStarted;
        Integer expectStateMachineStopped;
        Integer expectExtendedStateChanged;
        final Collection<Object> expectVariableKeys;
        final Map<Object, Object> expectVariables;

        public StateMachineTestPlanStep(List<E> sendEvent, List<Message<E>> sendMessage, Object sendEventMachineId, boolean sendEventToAll, boolean sendEventParallel, Collection<S> expectStates, Integer expectStateChanged, Integer expectStateEntered, Integer expectStateExited, Integer expectEventNotAccepted, Integer expectTransition, Integer expectTransitionStarted, Integer expectTransitionEnded, Integer expectStateMachineStarted, Integer expectStateMachineStopped, Collection<Object> expectVariableKeys, Map<Object, Object> expectVariables, Integer expectExtendedStateChanged, Collection<S> expectStatesEntrered, Collection<S> expectStatesExited) {
            this.sendEvent = sendEvent;
            this.sendMessage = sendMessage;
            this.sendEventMachineId = sendEventMachineId;
            this.sendEventToAll = sendEventToAll;
            this.sendEventParallel = sendEventParallel;
            this.expectStates = expectStates;
            this.expectStateChanged = expectStateChanged;
            this.expectStateEntered = expectStateEntered;
            this.expectStateExited = expectStateExited;
            this.expectEventNotAccepted = expectEventNotAccepted;
            this.expectTransition = expectTransition;
            this.expectTransitionStarted = expectTransitionStarted;
            this.expectTransitionEnded = expectTransitionEnded;
            this.expectStateMachineStarted = expectStateMachineStarted;
            this.expectStateMachineStopped = expectStateMachineStopped;
            this.expectVariableKeys = expectVariableKeys;
            this.expectVariables = expectVariables;
            this.expectExtendedStateChanged = expectExtendedStateChanged;
            this.expectStatesEntrered = expectStatesEntrered;
            this.expectStatesExited = expectStatesExited;
        }
    }

    public class StateMachineTestPlanStepBuilder {
        final List<E> sendEvent = new ArrayList();
        final List<Message<E>> sendMessage = new ArrayList();
        Object sendEventMachineId;
        boolean sendEventToAll = false;
        boolean sendEventParallel = false;
        final Collection<S> expectStates = new ArrayList();
        final Collection<S> expectStatesEntrered = new ArrayList();
        final Collection<S> expectStatesExited = new ArrayList();
        Integer expectStateChanged;
        Integer expectStateEntered;
        Integer expectStateExited;
        Integer expectEventNotAccepted;
        Integer expectTransition;
        Integer expectTransitionStarted;
        Integer expectTransitionEnded;
        Integer expectStateMachineStarted;
        Integer expectStateMachineStopped;
        Integer expectExtendedStateChanged;
        final Collection<Object> expectVariableKeys = new ArrayList<Object>();
        final Map<Object, Object> expectVariables = new HashMap<Object, Object>();

        public StateMachineTestPlanStepBuilder expectState(S state) {
            this.expectStates.add(state);
            return this;
        }

        public StateMachineTestPlanStepBuilder expectStates(S ... states) {
            this.expectStates.addAll(Arrays.asList(states));
            return this;
        }

        public StateMachineTestPlanStepBuilder sendEvent(E event) {
            return this.sendEvent(event, false);
        }

        public StateMachineTestPlanStepBuilder sendEvent(E event, boolean sendToAll) {
            this.sendEvent(event, sendToAll, false);
            return this;
        }

        public StateMachineTestPlanStepBuilder sendEvent(E event, boolean sendToAll, boolean sendParallel) {
            this.sendEvent.add(event);
            this.sendEventMachineId = null;
            this.sendEventToAll = sendToAll;
            this.sendEventParallel = sendParallel;
            return this;
        }

        public StateMachineTestPlanStepBuilder sendEvent(E event, Object machineId) {
            this.sendEvent.add(event);
            this.sendEventMachineId = machineId;
            return this;
        }

        public StateMachineTestPlanStepBuilder sendEvent(Message<E> event) {
            return this.sendEvent(event, false);
        }

        public StateMachineTestPlanStepBuilder sendEvent(Message<E> event, boolean sendToAll) {
            this.sendMessage.add(event);
            this.sendEventMachineId = null;
            this.sendEventToAll = sendToAll;
            return this;
        }

        public StateMachineTestPlanStepBuilder sendEvent(Message<E> event, Object machineId) {
            this.sendMessage.add(event);
            this.sendEventMachineId = machineId;
            return this;
        }

        public StateMachineTestPlanStepBuilder expectVariable(Object key) {
            this.expectVariableKeys.add(key);
            return this;
        }

        public StateMachineTestPlanStepBuilder expectVariable(Object key, Object value) {
            this.expectVariables.put(key, value);
            return this;
        }

        public StateMachineTestPlanStepBuilder expectStateChanged(int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Expected count cannot be negative, was " + count);
            }
            this.expectStateChanged = count;
            return this;
        }

        public StateMachineTestPlanStepBuilder expectStateEntered(S ... states) {
            this.expectStatesEntrered.addAll(Arrays.asList(states));
            return this;
        }

        public StateMachineTestPlanStepBuilder expectStateExited(S ... states) {
            this.expectStatesExited.addAll(Arrays.asList(states));
            return this;
        }

        public StateMachineTestPlanStepBuilder expectStateEntered(int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Expected count cannot be negative, was " + count);
            }
            this.expectStateEntered = count;
            return this;
        }

        public StateMachineTestPlanStepBuilder expectStateExited(int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Expected count cannot be negative, was " + count);
            }
            this.expectStateExited = count;
            return this;
        }

        public StateMachineTestPlanStepBuilder expectEventNotAccepted(int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Expected count cannot be negative, was " + count);
            }
            this.expectEventNotAccepted = count;
            return this;
        }

        public StateMachineTestPlanStepBuilder expectTransition(int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Expected count cannot be negative, was " + count);
            }
            this.expectTransition = count;
            return this;
        }

        public StateMachineTestPlanStepBuilder expectTransitionStarted(int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Expected count cannot be negative, was " + count);
            }
            this.expectTransitionStarted = count;
            return this;
        }

        public StateMachineTestPlanStepBuilder expectTransitionEnded(int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Expected count cannot be negative, was " + count);
            }
            this.expectTransitionEnded = count;
            return this;
        }

        public StateMachineTestPlanStepBuilder expectStateMachineStarted(int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Expected count cannot be negative, was " + count);
            }
            this.expectStateMachineStarted = count;
            return this;
        }

        public StateMachineTestPlanStepBuilder expectStateMachineStopped(int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Expected count cannot be negative, was " + count);
            }
            this.expectStateMachineStopped = count;
            return this;
        }

        public StateMachineTestPlanStepBuilder expectExtendedStateChanged(int count) {
            if (count < 0) {
                throw new IllegalArgumentException("Expected count cannot be negative, was " + count);
            }
            this.expectExtendedStateChanged = count;
            return this;
        }

        public StateMachineTestPlanBuilder<S, E> and() {
            StateMachineTestPlanBuilder.this.steps.add(new StateMachineTestPlanStep(this.sendEvent, this.sendMessage, this.sendEventMachineId, this.sendEventToAll, this.sendEventParallel, this.expectStates, this.expectStateChanged, this.expectStateEntered, this.expectStateExited, this.expectEventNotAccepted, this.expectTransition, this.expectTransitionStarted, this.expectTransitionEnded, this.expectStateMachineStarted, this.expectStateMachineStopped, this.expectVariableKeys, this.expectVariables, this.expectExtendedStateChanged, this.expectStatesEntrered, this.expectStatesExited));
            return StateMachineTestPlanBuilder.this;
        }
    }
}

