/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.test.StateMachineTestPlanBuilder;
import org.springframework.statemachine.test.support.LatchStateMachineListener;
import org.springframework.util.StringUtils;

public class StateMachineTestPlan<S, E> {
    private static final Log log = LogFactory.getLog(StateMachineTestPlan.class);
    private final Map<Object, StateMachine<S, E>> stateMachines;
    private final List<StateMachineTestPlanBuilder.StateMachineTestPlanStep<S, E>> steps;
    private Integer defaultAwaitTime = 10;

    public StateMachineTestPlan(Map<Object, StateMachine<S, E>> stateMachines, List<StateMachineTestPlanBuilder.StateMachineTestPlanStep<S, E>> steps, Integer defaultAwaitTime) {
        this.stateMachines = stateMachines;
        this.steps = steps;
        if (defaultAwaitTime != null) {
            this.defaultAwaitTime = defaultAwaitTime;
        }
    }

    public void test() throws Exception {
        HashMap listeners = new HashMap();
        for (StateMachine<S, E> stateMachine : this.stateMachines.values()) {
            LatchStateMachineListener listener = new LatchStateMachineListener();
            listeners.put(stateMachine, listener);
            stateMachine.addStateListener(listener);
        }
        log.info((Object)("Running test plan for machines " + StringUtils.collectionToCommaDelimitedString(this.stateMachines.values())));
        int stepCounter = 0;
        for (StateMachineTestPlanBuilder.StateMachineTestPlanStep<S, E> step : this.steps) {
            Map variables;
            ArrayList<Object> states;
            ArrayList<StateMachine<S, StateMachine<S, E>>> sendVia;
            log.info((Object)("Running test plan step " + stepCounter++));
            for (LatchStateMachineListener latchStateMachineListener : listeners.values()) {
                latchStateMachineListener.reset(step.expectStateChanged != null ? step.expectStateChanged : 0, step.expectStateEntered != null ? step.expectStateEntered : 0, step.expectStateExited != null ? step.expectStateExited : 0, step.expectEventNotAccepted != null ? step.expectEventNotAccepted : 0, step.expectTransition != null ? step.expectTransition : 0, step.expectTransitionStarted != null ? step.expectTransitionStarted : 0, step.expectTransitionEnded != null ? step.expectTransitionEnded : 0, step.expectStateMachineStarted != null ? step.expectStateMachineStarted : 0, step.expectStateMachineStopped != null ? step.expectStateMachineStopped : 0, step.expectExtendedStateChanged != null ? step.expectExtendedStateChanged : 0);
            }
            for (StateMachine stateMachine : this.stateMachines.values()) {
                stateMachine.start();
            }
            if (step.expectStateMachineStarted != null) {
                for (Map.Entry entry : listeners.entrySet()) {
                    Assert.assertThat((String)("StateMachineStarted Await not matched for machine " + entry.getKey()), (Object)((LatchStateMachineListener)((Object)entry.getValue())).getStateMachineStartedLatch().await(this.defaultAwaitTime.intValue(), TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((String)("StateMachineStarted count not matched for machine " + entry.getKey()), (Object)((LatchStateMachineListener)((Object)entry.getValue())).getStateMachineStarted().size(), (Matcher)Matchers.is((Object)step.expectStateMachineStarted));
                }
            }
            if (!step.sendEvent.isEmpty()) {
                sendVia = new ArrayList<StateMachine<S, StateMachine<S, E>>>();
                if (step.sendEventMachineId != null) {
                    sendVia.add(this.stateMachines.get(step.sendEventMachineId));
                } else if (step.sendEventToAll) {
                    sendVia.addAll(this.stateMachines.values());
                } else {
                    sendVia.add(this.stateMachines.values().iterator().next());
                }
                Assert.assertThat((String)"Error finding machine to send via", sendVia, (Matcher)Matchers.not((Matcher)Matchers.empty()));
                if (!step.sendEventParallel) {
                    for (StateMachine machine : sendVia) {
                        for (Object object : step.sendEvent) {
                            log.info((Object)("Sending test event " + object + " via machine " + machine));
                            machine.sendEvent(object);
                        }
                    }
                } else {
                    for (Object event : step.sendEvent) {
                        this.sendEventParallel(sendVia, event);
                    }
                }
            } else if (!step.sendMessage.isEmpty()) {
                sendVia = new ArrayList();
                if (step.sendEventMachineId != null) {
                    sendVia.add(this.stateMachines.get(step.sendEventMachineId));
                } else if (step.sendEventToAll) {
                    sendVia.addAll(this.stateMachines.values());
                } else {
                    sendVia.add(this.stateMachines.values().iterator().next());
                }
                Assert.assertThat((String)"Error finding machine to send via", sendVia, (Matcher)Matchers.not((Matcher)Matchers.empty()));
                for (StateMachine machine : sendVia) {
                    for (Message message : step.sendMessage) {
                        log.info((Object)("Sending test event " + message + " via machine " + machine));
                        machine.sendEvent(message);
                    }
                }
            }
            if (step.expectStateChanged != null) {
                for (Map.Entry entry : listeners.entrySet()) {
                    Assert.assertThat((String)("StateChanged Await not matched for machine " + entry.getKey()), (Object)((LatchStateMachineListener)((Object)entry.getValue())).getStateChangedLatch().await(this.defaultAwaitTime.intValue(), TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((String)("StateChanged count not matched for machine " + entry.getKey()), (Object)((LatchStateMachineListener)((Object)entry.getValue())).getStateChanged().size(), (Matcher)Matchers.is((Object)step.expectStateChanged));
                }
            }
            if (step.expectStateEntered != null) {
                for (LatchStateMachineListener latchStateMachineListener : listeners.values()) {
                    Assert.assertThat((Object)latchStateMachineListener.getStateEnteredLatch().await(this.defaultAwaitTime.intValue(), TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((Object)latchStateMachineListener.getStateEntered().size(), (Matcher)Matchers.is((Object)step.expectStateEntered));
                }
            }
            if (step.expectStateExited != null) {
                for (LatchStateMachineListener latchStateMachineListener : listeners.values()) {
                    Assert.assertThat((Object)latchStateMachineListener.getStateExitedLatch().await(this.defaultAwaitTime.intValue(), TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((Object)latchStateMachineListener.getStateExited().size(), (Matcher)Matchers.is((Object)step.expectStateExited));
                }
            }
            if (step.expectEventNotAccepted != null) {
                for (LatchStateMachineListener latchStateMachineListener : listeners.values()) {
                    Assert.assertThat((Object)latchStateMachineListener.getEventNotAcceptedLatch().await(this.defaultAwaitTime.intValue(), TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((Object)latchStateMachineListener.getEventNotAccepted().size(), (Matcher)Matchers.is((Object)step.expectEventNotAccepted));
                }
            }
            if (step.expectTransition != null) {
                for (LatchStateMachineListener latchStateMachineListener : listeners.values()) {
                    Assert.assertThat((Object)latchStateMachineListener.getTransitionLatch().await(this.defaultAwaitTime.intValue(), TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((Object)latchStateMachineListener.getTransition().size(), (Matcher)Matchers.is((Object)step.expectTransition));
                }
            }
            if (step.expectTransitionStarted != null) {
                for (LatchStateMachineListener latchStateMachineListener : listeners.values()) {
                    Assert.assertThat((Object)latchStateMachineListener.getTransitionStartedLatch().await(this.defaultAwaitTime.intValue(), TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((Object)latchStateMachineListener.getTransitionStarted().size(), (Matcher)Matchers.is((Object)step.expectTransitionStarted));
                }
            }
            if (step.expectTransitionEnded != null) {
                for (LatchStateMachineListener latchStateMachineListener : listeners.values()) {
                    Assert.assertThat((Object)latchStateMachineListener.getTransitionEndedLatch().await(this.defaultAwaitTime.intValue(), TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((Object)latchStateMachineListener.getTransitionEnded().size(), (Matcher)Matchers.is((Object)step.expectTransitionEnded));
                }
            }
            if (step.expectStateMachineStopped != null) {
                for (LatchStateMachineListener latchStateMachineListener : listeners.values()) {
                    Assert.assertThat((Object)latchStateMachineListener.getStateMachineStoppedLatch().await(this.defaultAwaitTime.intValue(), TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((Object)latchStateMachineListener.getStateMachineStopped().size(), (Matcher)Matchers.is((Object)step.expectStateMachineStopped));
                }
            }
            if (!step.expectStates.isEmpty()) {
                for (StateMachine stateMachine : this.stateMachines.values()) {
                    Assert.assertThat((Object)stateMachine.getState(), (Matcher)Matchers.notNullValue());
                    ArrayList<Matcher> itemMatchers = new ArrayList<Matcher>();
                    for (Object object : step.expectStates) {
                        itemMatchers.add(Matchers.is((Object)object));
                    }
                    Assert.assertThat((Object)stateMachine.getState().getIds(), (Matcher)Matchers.containsInAnyOrder(itemMatchers));
                }
            }
            if (!step.expectStatesEntrered.isEmpty()) {
                for (LatchStateMachineListener latchStateMachineListener : listeners.values()) {
                    states = new ArrayList<Object>();
                    for (State state : latchStateMachineListener.getStateEntered()) {
                        states.add(state.getId());
                    }
                    Assert.assertThat(step.expectStatesEntrered, (Matcher)Matchers.contains((Object[])states.toArray()));
                }
            }
            if (!step.expectStatesExited.isEmpty()) {
                for (LatchStateMachineListener latchStateMachineListener : listeners.values()) {
                    states = new ArrayList();
                    for (State state : latchStateMachineListener.getStateExited()) {
                        states.add(state.getId());
                    }
                    Assert.assertThat(step.expectStatesExited, (Matcher)Matchers.contains((Object[])states.toArray()));
                }
            }
            if (step.expectExtendedStateChanged != null) {
                for (LatchStateMachineListener latchStateMachineListener : listeners.values()) {
                    Assert.assertThat((Object)latchStateMachineListener.getExtendedStateChangedLatch().await(this.defaultAwaitTime.intValue(), TimeUnit.SECONDS), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((Object)latchStateMachineListener.getExtendedStateChanged().size(), (Matcher)Matchers.is((Object)step.expectExtendedStateChanged));
                }
            }
            if (!step.expectVariableKeys.isEmpty()) {
                for (StateMachine stateMachine : this.stateMachines.values()) {
                    variables = stateMachine.getExtendedState().getVariables();
                    for (Object object : step.expectVariableKeys) {
                        Assert.assertThat((String)("Key " + object + " doesn't exist in extended state variables"), (Object)variables.containsKey(object), (Matcher)Matchers.is((Object)true));
                    }
                }
            }
            if (step.expectVariables.isEmpty()) continue;
            for (StateMachine stateMachine : this.stateMachines.values()) {
                variables = stateMachine.getExtendedState().getVariables();
                for (Map.Entry entry : step.expectVariables.entrySet()) {
                    Assert.assertThat((String)("Key " + entry.getKey() + " doesn't exist in extended state variables"), (Object)variables.containsKey(entry.getKey()), (Matcher)Matchers.is((Object)true));
                    Assert.assertThat((String)("Variable " + entry.getKey() + " doesn't match in extended state variables"), variables.get(entry.getKey()), (Matcher)Matchers.is(entry.getValue()));
                }
            }
        }
    }

    private void sendEventParallel(List<StateMachine<S, E>> machines, final E event) {
        final CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Thread> joins = new ArrayList<Thread>();
        int threadCount = machines.size();
        for (int i = 0; i < threadCount; ++i) {
            final StateMachine<S, E> machine = machines.get(i);
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    try {
                        latch.await();
                        machine.sendEvent(event);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            Thread t = new Thread(runner, "EventSenderThread" + i);
            joins.add(t);
            t.start();
        }
        latch.countDown();
        for (Thread t : joins) {
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

