/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.recipes.tasks;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachineException;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.StateMachineBuilder;
import org.springframework.statemachine.config.builders.StateMachineStateConfigurer;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ExternalTransitionConfigurer;
import org.springframework.statemachine.config.configurers.InternalTransitionConfigurer;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.listener.AbstractCompositeListener;
import org.springframework.statemachine.recipes.support.RunnableAction;
import org.springframework.statemachine.region.RegionExecutionPolicy;
import org.springframework.statemachine.state.PseudoStateKind;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.DefaultStateMachineContext;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.support.StateMachineInterceptorAdapter;
import org.springframework.statemachine.support.StateMachineUtils;
import org.springframework.statemachine.support.tree.Tree;
import org.springframework.statemachine.support.tree.TreeTraverser;
import org.springframework.statemachine.transition.Transition;
import reactor.core.publisher.Mono;

public class TasksHandler {
    private static final Log log = LogFactory.getLog(TasksHandler.class);
    public static final String STATE_READY = "READY";
    public static final String STATE_FORK = "FORK";
    public static final String STATE_TASKS = "TASKS";
    public static final String STATE_JOIN = "JOIN";
    public static final String STATE_CHOICE = "CHOICE";
    public static final String STATE_ERROR = "ERROR";
    public static final String STATE_AUTOMATIC = "AUTOMATIC";
    public static final String STATE_MANUAL = "MANUAL";
    public static final String STATE_TASKS_PREFIX = "TASK_";
    public static final String STATE_TASKS_INITIAL_POSTFIX = "_INITIAL";
    public static final String EVENT_RUN = "RUN";
    public static final String EVENT_FALLBACK = "FALLBACK";
    public static final String EVENT_CONTINUE = "CONTINUE";
    public static final String EVENT_FIX = "FIX";
    private StateMachine<String, String> stateMachine;
    private final CompositeTasksListener listener = new CompositeTasksListener();
    private final StateMachinePersist<String, String, Void> persist;

    private TasksHandler(List<TaskWrapper> tasks, TasksListener listener, TaskExecutor taskExecutor, StateMachinePersist<String, String, Void> persist) {
        this.persist = persist;
        try {
            this.stateMachine = this.buildStateMachine(tasks, taskExecutor);
            if (persist != null) {
                LocalStateMachineInterceptor interceptor = new LocalStateMachineInterceptor(persist);
                this.stateMachine.getStateMachineAccessor().doWithAllRegions(function -> function.addStateMachineInterceptor((StateMachineInterceptor)interceptor));
            }
        }
        catch (Exception e) {
            throw new StateMachineException("Error building state machine from tasks", e);
        }
        if (listener != null) {
            this.addTasksListener(listener);
        }
    }

    public void runTasks() {
        this.stateMachine.sendEvent(Mono.just((Object)MessageBuilder.withPayload((Object)EVENT_RUN).build())).subscribe();
    }

    public void continueFromError() {
        this.stateMachine.sendEvent(Mono.just((Object)MessageBuilder.withPayload((Object)EVENT_CONTINUE).build())).subscribe();
    }

    public void fixCurrentProblems() {
        this.stateMachine.sendEvent(Mono.just((Object)MessageBuilder.withPayload((Object)EVENT_FIX).build())).subscribe();
    }

    public void resetFromPersistStore() {
        StateMachineContext context;
        if (this.persist == null) {
            return;
        }
        try {
            context = this.persist.read(null);
        }
        catch (Exception e) {
            throw new StateMachineException("Error reading state from persistent store", e);
        }
        this.stateMachine.stopReactively().block();
        this.stateMachine.getStateMachineAccessor().doWithAllRegions(function -> function.resetStateMachineReactively(context).block());
        this.stateMachine.startReactively().block();
    }

    public void addTasksListener(TasksListener listener) {
        this.listener.register(listener);
    }

    public void removeTasksListener(TasksListener listener) {
        this.listener.unregister(listener);
    }

    public StateMachine<String, String> getStateMachine() {
        return this.stateMachine;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void markAllTasksFixed() {
        Map variables = this.getStateMachine().getExtendedState().getVariables();
        for (Map.Entry entry : variables.entrySet()) {
            Integer value;
            if (!(entry.getKey() instanceof String) || !((String)entry.getKey()).startsWith(STATE_TASKS_PREFIX) || !(entry.getValue() instanceof Integer) || (value = (Integer)entry.getValue()) >= 0) continue;
            variables.put(entry.getKey(), 0);
        }
    }

    private StateMachine<String, String> buildStateMachine(List<TaskWrapper> tasks, TaskExecutor taskExecutor) throws Exception {
        Tree.Node<TaskWrapper> node;
        StateMachineBuilder.Builder builder = StateMachineBuilder.builder();
        int taskCount = TasksHandler.topLevelTaskCount(tasks);
        if (taskCount > 1) {
            builder.configureConfiguration().withConfiguration().regionExecutionPolicy(RegionExecutionPolicy.PARALLEL);
        }
        StateMachineStateConfigurer stateMachineStateConfigurer = builder.configureStates();
        StateMachineTransitionConfigurer stateMachineTransitionConfigurer = builder.configureTransitions();
        stateMachineStateConfigurer.withStates().initial((Object)STATE_READY).fork((Object)STATE_FORK).state((Object)STATE_TASKS, (Action)this.tasksEntryAction(), null).join((Object)STATE_JOIN).choice((Object)STATE_CHOICE).state((Object)STATE_ERROR);
        ((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)stateMachineTransitionConfigurer.withExternal().source((Object)STATE_READY)).target((Object)STATE_FORK).event((Object)EVENT_RUN)).and()).withFork().source((Object)STATE_FORK).target((Object)STATE_TASKS);
        Iterator<Tree.Node<TaskWrapper>> iterator = TasksHandler.buildTasksIterator(tasks);
        String parent = null;
        ArrayList<CallSite> joinStates = new ArrayList<CallSite>();
        while (iterator.hasNext() && (node = iterator.next()).getData() != null) {
            String initial = STATE_TASKS_PREFIX + ((TaskWrapper)node.getData()).id.toString() + STATE_TASKS_INITIAL_POSTFIX;
            String task = STATE_TASKS_PREFIX + ((TaskWrapper)node.getData()).id.toString();
            parent = ((TaskWrapper)node.getData()).parent != null ? STATE_TASKS_PREFIX + ((TaskWrapper)node.getData()).parent.toString() : STATE_TASKS;
            stateMachineStateConfigurer.withStates().parent((Object)parent).initial((Object)initial).state((Object)task, (Action)this.runnableAction(((TaskWrapper)node.getData()).runnable, ((TaskWrapper)node.getData()).id.toString()), null);
            if (node.getChildren().isEmpty()) {
                joinStates.add((CallSite)((Object)task));
            }
            ((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)stateMachineTransitionConfigurer.withExternal().state((Object)parent)).source((Object)initial)).target((Object)task);
        }
        stateMachineStateConfigurer.withStates().parent((Object)STATE_ERROR).initial((Object)STATE_AUTOMATIC).state((Object)STATE_AUTOMATIC, this.automaticAction(), null).state((Object)STATE_MANUAL);
        ((InternalTransitionConfigurer)((InternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)stateMachineTransitionConfigurer.withJoin().sources(joinStates).target((Object)STATE_JOIN).and()).withExternal().source((Object)STATE_JOIN)).target((Object)STATE_CHOICE).and()).withChoice().source((Object)STATE_CHOICE).first((Object)STATE_ERROR, this.tasksChoiceGuard()).last((Object)STATE_READY).and()).withExternal().source((Object)STATE_ERROR)).target((Object)STATE_READY).event((Object)EVENT_CONTINUE)).action(this.continueAction())).and()).withExternal().source((Object)STATE_AUTOMATIC)).target((Object)STATE_MANUAL).event((Object)EVENT_FALLBACK)).and()).withInternal().source((Object)STATE_MANUAL)).action(this.fixAction())).event((Object)EVENT_FIX);
        return builder.build();
    }

    private static int topLevelTaskCount(List<TaskWrapper> tasks) {
        Tree tree = new Tree();
        for (TaskWrapper wrapper : tasks) {
            tree.add((Object)wrapper, wrapper.id, wrapper.parent);
        }
        return tree.getRoot().getChildren().size();
    }

    private static Iterator<Tree.Node<TaskWrapper>> buildTasksIterator(List<TaskWrapper> tasks) {
        Tree tree = new Tree();
        for (TaskWrapper wrapper : tasks) {
            tree.add((Object)wrapper, wrapper.id, wrapper.parent);
        }
        TreeTraverser<Tree.Node<TaskWrapper>> traverser = new TreeTraverser<Tree.Node<TaskWrapper>>(){

            public Iterable<Tree.Node<TaskWrapper>> children(Tree.Node<TaskWrapper> root) {
                return root.getChildren();
            }
        };
        Iterable postOrderTraversal = traverser.postOrderTraversal((Object)tree.getRoot());
        Iterator<Tree.Node<TaskWrapper>> iterator = postOrderTraversal.iterator();
        return iterator;
    }

    private TasksEntryAction tasksEntryAction() {
        return new TasksEntryAction();
    }

    private LocalRunnableAction runnableAction(Runnable runnable, String id) {
        return new LocalRunnableAction(runnable, id);
    }

    private Guard<String, String> tasksChoiceGuard() {
        return new Guard<String, String>(){

            public boolean evaluate(StateContext<String, String> context) {
                Map variables = context.getExtendedState().getVariables();
                for (Map.Entry entry : variables.entrySet()) {
                    Integer value;
                    if (!(entry.getKey() instanceof String) || !((String)entry.getKey()).startsWith(TasksHandler.STATE_TASKS_PREFIX) || !(entry.getValue() instanceof Integer) || (value = (Integer)entry.getValue()) >= 0) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Task id=[" + entry.getKey() + "] has negative execution value, tasksChoiceGuard returns true"));
                    }
                    TasksHandler.this.listener.onTasksError();
                    return true;
                }
                TasksHandler.this.listener.onTasksSuccess();
                return false;
            }
        };
    }

    private Action<String, String> continueAction() {
        return new Action<String, String>(){

            public void execute(StateContext<String, String> context) {
                TasksHandler.this.listener.onTasksContinue();
            }
        };
    }

    private Action<String, String> automaticAction() {
        return new Action<String, String>(){

            public void execute(StateContext<String, String> context) {
                TasksHandler.this.listener.onTasksAutomaticFix(TasksHandler.this, context);
                boolean hasErrors = false;
                Map variables = context.getExtendedState().getVariables();
                for (Map.Entry entry : variables.entrySet()) {
                    Integer value;
                    if (!(entry.getKey() instanceof String) || !((String)entry.getKey()).startsWith(TasksHandler.STATE_TASKS_PREFIX) || !(entry.getValue() instanceof Integer) || (value = (Integer)entry.getValue()) >= 0) continue;
                    hasErrors = true;
                    break;
                }
                if (hasErrors) {
                    context.getStateMachine().sendEvent(Mono.just((Object)MessageBuilder.withPayload((Object)TasksHandler.EVENT_FALLBACK).build())).subscribe();
                } else {
                    context.getStateMachine().sendEvent(Mono.just((Object)MessageBuilder.withPayload((Object)TasksHandler.EVENT_CONTINUE).build())).subscribe();
                }
            }
        };
    }

    private Action<String, String> fixAction() {
        return new Action<String, String>(){

            public void execute(StateContext<String, String> context) {
                Map variables = context.getExtendedState().getVariables();
                for (Map.Entry entry : variables.entrySet()) {
                    Integer value;
                    if (!(entry.getKey() instanceof String) || !((String)entry.getKey()).startsWith(TasksHandler.STATE_TASKS_PREFIX) || !(entry.getValue() instanceof Integer) || (value = (Integer)entry.getValue()) >= 0) continue;
                    variables.put(entry.getKey(), 0);
                }
            }
        };
    }

    private class CompositeTasksListener
    extends AbstractCompositeListener<TasksListener>
    implements TasksListener {
        private CompositeTasksListener() {
        }

        @Override
        public void onTasksStarted() {
            Iterator iterator = this.getListeners().reverse();
            while (iterator.hasNext()) {
                ((TasksListener)iterator.next()).onTasksStarted();
            }
        }

        @Override
        public void onTasksContinue() {
            Iterator iterator = this.getListeners().reverse();
            while (iterator.hasNext()) {
                ((TasksListener)iterator.next()).onTasksContinue();
            }
        }

        @Override
        public void onTaskPreExecute(Object id) {
            Iterator iterator = this.getListeners().reverse();
            while (iterator.hasNext()) {
                ((TasksListener)iterator.next()).onTaskPreExecute(id);
            }
        }

        @Override
        public void onTaskPostExecute(Object id) {
            Iterator iterator = this.getListeners().reverse();
            while (iterator.hasNext()) {
                ((TasksListener)iterator.next()).onTaskPostExecute(id);
            }
        }

        @Override
        public void onTaskFailed(Object id, Exception exception) {
            Iterator iterator = this.getListeners().reverse();
            while (iterator.hasNext()) {
                ((TasksListener)iterator.next()).onTaskFailed(id, exception);
            }
        }

        @Override
        public void onTaskSuccess(Object id) {
            Iterator iterator = this.getListeners().reverse();
            while (iterator.hasNext()) {
                ((TasksListener)iterator.next()).onTaskSuccess(id);
            }
        }

        @Override
        public void onTasksSuccess() {
            Iterator iterator = this.getListeners().reverse();
            while (iterator.hasNext()) {
                ((TasksListener)iterator.next()).onTasksSuccess();
            }
        }

        @Override
        public void onTasksError() {
            Iterator iterator = this.getListeners().reverse();
            while (iterator.hasNext()) {
                ((TasksListener)iterator.next()).onTasksError();
            }
        }

        @Override
        public void onTasksAutomaticFix(TasksHandler handler, StateContext<String, String> context) {
            Iterator iterator = this.getListeners().reverse();
            while (iterator.hasNext()) {
                ((TasksListener)iterator.next()).onTasksAutomaticFix(handler, context);
            }
        }
    }

    private class LocalStateMachineInterceptor
    extends StateMachineInterceptorAdapter<String, String> {
        private final StateMachinePersist<String, String, Void> persist;
        private DefaultStateMachineContext<String, String> currentContext;
        private State<String, String> currentContextState;
        private final List<StateMachineContext<String, String>> childs = new ArrayList<StateMachineContext<String, String>>();

        public LocalStateMachineInterceptor(StateMachinePersist<String, String, Void> persist) {
            this.persist = persist;
        }

        public void preStateChange(State<String, String> state, Message<String> message, Transition<String, String> transition, StateMachine<String, String> stateMachine, StateMachine<String, String> rootStateMachine) {
            if (state == null || state.getPseudoState() != null && state.getPseudoState().getKind() != PseudoStateKind.INITIAL) {
                return;
            }
            if (this.currentContext != null && StateMachineUtils.isSubstate(this.currentContextState, state)) {
                context = new DefaultStateMachineContext((Object)(transition != null ? (String)transition.getTarget().getId() : null), (Object)(message != null ? (String)message.getPayload() : null), (Map)(message != null ? message.getHeaders() : null), stateMachine.getExtendedState());
                this.currentContext.getChilds().add(context);
            } else {
                this.childs.clear();
                this.currentContext = context = new DefaultStateMachineContext(new ArrayList<StateMachineContext<String, String>>(this.childs), (Object)((String)state.getId()), (Object)(message != null ? (String)message.getPayload() : null), (Map)(message != null ? message.getHeaders() : null), stateMachine.getExtendedState());
                this.currentContextState = state;
            }
            try {
                this.persist.write(this.currentContext, null);
            }
            catch (Exception e) {
                throw new StateMachineException("Error persisting", e);
            }
        }
    }

    public static interface TasksListener {
        public void onTasksStarted();

        public void onTasksContinue();

        public void onTaskPreExecute(Object var1);

        public void onTaskPostExecute(Object var1);

        public void onTaskFailed(Object var1, Exception var2);

        public void onTaskSuccess(Object var1);

        public void onTasksSuccess();

        public void onTasksError();

        public void onTasksAutomaticFix(TasksHandler var1, StateContext<String, String> var2);
    }

    public static class Builder {
        private final List<TaskWrapper> tasks = new ArrayList<TaskWrapper>();
        private TasksListener listener;
        private TaskExecutor taskExecutor;
        private StateMachinePersist<String, String, Void> persist;

        public Builder task(Object id, Runnable runnable) {
            this.tasks.add(new TaskWrapper(null, id, runnable));
            return this;
        }

        public Builder task(Object parent, Object id, Runnable runnable) {
            this.tasks.add(new TaskWrapper(parent, id, runnable));
            return this;
        }

        public Builder persist(StateMachinePersist<String, String, Void> persist) {
            this.persist = persist;
            return this;
        }

        public Builder listener(TasksListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder taskExecutor(TaskExecutor taskExecutor) {
            this.taskExecutor = taskExecutor;
            return this;
        }

        public TasksHandler build() {
            return new TasksHandler(this.tasks, this.listener, this.taskExecutor, this.persist);
        }
    }

    private class TasksEntryAction
    implements Action<String, String> {
        private TasksEntryAction() {
        }

        public void execute(StateContext<String, String> context) {
            boolean hasErrors = false;
            Map variables = context.getExtendedState().getVariables();
            for (Map.Entry entry : variables.entrySet()) {
                Integer value;
                if (!(entry.getKey() instanceof String) || !((String)entry.getKey()).startsWith(TasksHandler.STATE_TASKS_PREFIX) || !(entry.getValue() instanceof Integer) || (value = (Integer)entry.getValue()) >= 0) continue;
                hasErrors = true;
                break;
            }
            if (hasErrors) {
                TasksHandler.this.listener.onTasksContinue();
            } else {
                TasksHandler.this.listener.onTasksStarted();
            }
        }
    }

    private static class TaskWrapper {
        final Object parent;
        final Object id;
        final Runnable runnable;

        public TaskWrapper(Object parent, Object id, Runnable runnable) {
            this.parent = parent;
            this.id = id;
            this.runnable = runnable;
        }
    }

    private class LocalRunnableAction
    extends RunnableAction {
        public LocalRunnableAction(Runnable runnable, String id) {
            super(runnable, id);
        }

        @Override
        protected boolean shouldExecute(String id, StateContext<String, String> context) {
            return super.shouldExecute(id, context);
        }

        @Override
        protected void onPreExecute(String id, StateContext<String, String> context) {
            TasksHandler.this.listener.onTaskPreExecute(id);
        }

        @Override
        protected void onPostExecute(String id, StateContext<String, String> context) {
            TasksHandler.this.listener.onTaskPostExecute(id);
        }

        @Override
        protected void onSuccess(String id, StateContext<String, String> context) {
            TasksHandler.this.listener.onTaskSuccess(id);
            this.changeCount(1, context);
        }

        @Override
        protected void onError(String id, StateContext<String, String> context, Exception e) {
            TasksHandler.this.listener.onTaskFailed(id, e);
            this.changeCount(-1, context);
        }

        private void changeCount(int delta, StateContext<String, String> context) {
            String key;
            Map variables = context.getExtendedState().getVariables();
            Integer count = variables.containsKey(key = TasksHandler.STATE_TASKS_PREFIX + this.getId()) ? (Integer)variables.get(key) : Integer.valueOf(0);
            count = delta;
            variables.put(key, count);
        }
    }

    public static class TasksListenerAdapter
    implements TasksListener {
        @Override
        public void onTasksStarted() {
        }

        @Override
        public void onTasksContinue() {
        }

        @Override
        public void onTaskPreExecute(Object id) {
        }

        @Override
        public void onTaskPostExecute(Object id) {
        }

        @Override
        public void onTaskFailed(Object id, Exception exception) {
        }

        @Override
        public void onTaskSuccess(Object id) {
        }

        @Override
        public void onTasksSuccess() {
        }

        @Override
        public void onTasksError() {
        }

        @Override
        public void onTasksAutomaticFix(TasksHandler handler, StateContext<String, String> context) {
        }
    }
}

