/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.recipes.persist;

import java.util.Iterator;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.messaging.Message;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.access.StateMachineAccess;
import org.springframework.statemachine.listener.AbstractCompositeListener;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.support.DefaultStateMachineContext;
import org.springframework.statemachine.support.LifecycleObjectSupport;
import org.springframework.statemachine.support.StateMachineInterceptor;
import org.springframework.statemachine.support.StateMachineInterceptorAdapter;
import org.springframework.statemachine.transition.Transition;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractPersistStateMachineHandler<S, E>
extends LifecycleObjectSupport {
    protected final PersistingStateChangeInterceptor interceptor = new PersistingStateChangeInterceptor();
    protected final CompositePersistStateChangeListener listeners = new CompositePersistStateChangeListener();

    protected abstract StateMachine<S, E> getInitStateMachine();

    protected void initStateMachine(StateMachine<S, E> stateMachine) {
        List withAllRegions = stateMachine.getStateMachineAccessor().withAllRegions();
        for (StateMachineAccess a : withAllRegions) {
            a.addStateMachineInterceptor((StateMachineInterceptor)this.interceptor);
        }
    }

    @Deprecated
    public boolean handleEventWithState(Message<E> event, S state) {
        StateMachine<S, E> stateMachine = this.getInitStateMachine();
        stateMachine.stopReactively().block();
        List withAllRegions = stateMachine.getStateMachineAccessor().withAllRegions();
        for (StateMachineAccess a : withAllRegions) {
            a.resetStateMachineReactively((StateMachineContext)new DefaultStateMachineContext(state, null, null, null)).block();
        }
        stateMachine.startReactively().block();
        return stateMachine.sendEvent(event);
    }

    public Mono<Void> handleEventWithStateReactively(Message<E> event, S state) {
        return Mono.defer(() -> {
            StateMachine<S, E> stateMachine = this.getInitStateMachine();
            return Mono.from((Publisher)stateMachine.stopReactively()).thenEmpty((Publisher)Flux.fromIterable((Iterable)stateMachine.getStateMachineAccessor().withAllRegions()).flatMap(region -> region.resetStateMachineReactively((StateMachineContext)new DefaultStateMachineContext(state, null, null, null)))).then(stateMachine.startReactively()).thenMany((Publisher)stateMachine.sendEvent(Mono.just((Object)event))).then();
        });
    }

    public void addPersistStateChangeListener(GenericPersistStateChangeListener<S, E> listener) {
        this.listeners.register(listener);
    }

    private class PersistingStateChangeInterceptor
    extends StateMachineInterceptorAdapter<S, E> {
        private PersistingStateChangeInterceptor() {
        }

        public void preStateChange(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine, StateMachine<S, E> rootStateMachine) {
            AbstractPersistStateMachineHandler.this.listeners.onPersist(state, message, transition, stateMachine);
        }
    }

    private class CompositePersistStateChangeListener
    extends AbstractCompositeListener<GenericPersistStateChangeListener<S, E>>
    implements GenericPersistStateChangeListener<S, E> {
        private CompositePersistStateChangeListener() {
        }

        @Override
        public void onPersist(State<S, E> state, Message<E> message, Transition<S, E> transition, StateMachine<S, E> stateMachine) {
            Iterator iterator = this.getListeners().reverse();
            while (iterator.hasNext()) {
                GenericPersistStateChangeListener listener = (GenericPersistStateChangeListener)iterator.next();
                listener.onPersist(state, message, transition, stateMachine);
            }
        }
    }

    public static interface GenericPersistStateChangeListener<S, E> {
        public void onPersist(State<S, E> var1, Message<E> var2, Transition<S, E> var3, StateMachine<S, E> var4);
    }
}

