/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.recipes.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.action.Action;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;

public class RunnableAction
implements Action<String, String> {
    private static final Log log = LogFactory.getLog(RunnableAction.class);
    private final Runnable runnable;
    private final String id;

    public RunnableAction(Runnable runnable) {
        this(runnable, null);
    }

    public RunnableAction(Runnable runnable, String id) {
        Assert.notNull((Object)runnable, (String)"Runnable must be set");
        this.runnable = runnable;
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(StateContext<String, String> context) {
        if (!this.shouldExecute(this.id, context)) {
            return;
        }
        StopWatch watch = new StopWatch();
        String logId = this.id == null ? "" : " id=" + this.id;
        log.info((Object)("Executing runnable" + logId));
        if (log.isDebugEnabled()) {
            watch.start();
        }
        try {
            this.onPreExecute(this.id, context);
            this.runnable.run();
            this.onSuccess(this.id, context);
        }
        catch (Exception e) {
            this.onError(this.id, context, e);
        }
        finally {
            this.onPostExecute(this.id, context);
        }
        if (log.isDebugEnabled()) {
            watch.stop();
            log.debug((Object)("Runnable execution took " + watch.getTotalTimeMillis() + " ms" + logId));
        }
    }

    public String getId() {
        return this.id;
    }

    protected boolean shouldExecute(String id, StateContext<String, String> context) {
        return true;
    }

    protected void onPreExecute(String id, StateContext<String, String> context) {
    }

    protected void onPostExecute(String id, StateContext<String, String> context) {
    }

    protected void onSuccess(String id, StateContext<String, String> context) {
    }

    protected void onError(String id, StateContext<String, String> context, Exception e) {
    }
}

