/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.data.redis;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.messaging.MessageHeaders;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachineContextRepository;
import org.springframework.statemachine.kryo.MessageHeadersSerializer;
import org.springframework.statemachine.kryo.StateMachineContextSerializer;
import org.springframework.statemachine.kryo.UUIDSerializer;

public class RedisStateMachineContextRepository<S, E>
implements StateMachineContextRepository<S, E, StateMachineContext<S, E>> {
    private static final ThreadLocal<Kryo> kryoThreadLocal = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            Kryo kryo = new Kryo();
            kryo.addDefaultSerializer(StateMachineContext.class, (Serializer)new StateMachineContextSerializer());
            kryo.addDefaultSerializer(MessageHeaders.class, (Serializer)new MessageHeadersSerializer());
            kryo.addDefaultSerializer(UUID.class, (Serializer)new UUIDSerializer());
            return kryo;
        }
    };
    private final RedisOperations<String, byte[]> redisOperations;

    public RedisStateMachineContextRepository(RedisConnectionFactory redisConnectionFactory) {
        this.redisOperations = RedisStateMachineContextRepository.createDefaultTemplate(redisConnectionFactory);
    }

    public void save(StateMachineContext<S, E> context, String id) {
        this.redisOperations.opsForValue().set((Object)id, (Object)this.serialize(context));
    }

    public StateMachineContext<S, E> getContext(String id) {
        return this.deserialize((byte[])this.redisOperations.opsForValue().get((Object)id));
    }

    private static RedisTemplate<String, byte[]> createDefaultTemplate(RedisConnectionFactory connectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setConnectionFactory(connectionFactory);
        template.afterPropertiesSet();
        return template;
    }

    private byte[] serialize(StateMachineContext<S, E> context) {
        Kryo kryo = kryoThreadLocal.get();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)out);
        kryo.writeObject(output, context);
        output.close();
        return out.toByteArray();
    }

    private StateMachineContext<S, E> deserialize(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        Kryo kryo = kryoThreadLocal.get();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        Input input = new Input((InputStream)in);
        return (StateMachineContext)kryo.readObject(input, StateMachineContext.class);
    }
}

