/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.data.redis;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Set;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Reference;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.index.Indexed;
import org.springframework.statemachine.data.RepositoryTransition;
import org.springframework.statemachine.data.redis.RedisRepositoryAction;
import org.springframework.statemachine.data.redis.RedisRepositoryGuard;
import org.springframework.statemachine.data.redis.RedisRepositoryState;
import org.springframework.statemachine.transition.TransitionKind;

@RedisHash(value="RedisRepositoryTransition")
@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
public class RedisRepositoryTransition
extends RepositoryTransition {
    @Id
    private String id;
    @Indexed
    private String machineId = "";
    @Reference
    private RedisRepositoryState source;
    @Reference
    private RedisRepositoryState target;
    private String event;
    private TransitionKind kind;
    @Reference
    private Set<RedisRepositoryAction> actions;
    @Reference
    private RedisRepositoryGuard guard;

    public RedisRepositoryTransition() {
        this(null, null, null);
    }

    public RedisRepositoryTransition(RedisRepositoryState source, RedisRepositoryState target, String event) {
        this(null, source, target, event);
    }

    public RedisRepositoryTransition(String machineId, RedisRepositoryState source, RedisRepositoryState target, String event) {
        this(machineId, source, target, event, null);
    }

    public RedisRepositoryTransition(String machineId, RedisRepositoryState source, RedisRepositoryState target, String event, Set<RedisRepositoryAction> actions) {
        this.machineId = machineId == null ? "" : machineId;
        this.source = source;
        this.target = target;
        this.event = event;
        this.actions = actions;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public RedisRepositoryState getSource() {
        return this.source;
    }

    public void setSource(RedisRepositoryState source) {
        this.source = source;
    }

    public RedisRepositoryState getTarget() {
        return this.target;
    }

    public void setTarget(RedisRepositoryState target) {
        this.target = target;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public Set<RedisRepositoryAction> getActions() {
        return this.actions;
    }

    public void setActions(Set<RedisRepositoryAction> actions) {
        this.actions = actions;
    }

    public RedisRepositoryGuard getGuard() {
        return this.guard;
    }

    public void setGuard(RedisRepositoryGuard guard) {
        this.guard = guard;
    }

    public TransitionKind getKind() {
        return this.kind;
    }

    public void setKind(TransitionKind kind) {
        this.kind = kind;
    }

    public String toString() {
        return "RedisRepositoryTransition [id=" + this.id + ", machineId=" + this.machineId + ", source=" + (Object)((Object)this.source) + ", target=" + (Object)((Object)this.target) + ", event=" + this.event + ", kind=" + this.kind + ", actions=" + this.actions + ", guard=" + (Object)((Object)this.guard) + "]";
    }
}

