/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.data.redis;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Set;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Reference;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.index.Indexed;
import org.springframework.statemachine.data.RepositoryAction;
import org.springframework.statemachine.data.RepositoryState;
import org.springframework.statemachine.data.redis.RedisRepositoryAction;
import org.springframework.statemachine.state.PseudoStateKind;

@RedisHash(value="RedisRepositoryState")
@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
public class RedisRepositoryState
extends RepositoryState {
    @Id
    private String id;
    @Indexed
    private String machineId = "";
    private String state;
    private String region;
    private boolean initial;
    private PseudoStateKind kind;
    private String submachineId;
    @Reference
    private RedisRepositoryState parentState;
    @Reference
    private RedisRepositoryAction initialAction;
    @Reference
    private Set<RedisRepositoryAction> stateActions;
    @Reference
    private Set<RedisRepositoryAction> entryActions;
    @Reference
    private Set<RedisRepositoryAction> exitActions;
    private Set<String> deferredEvents;

    public RedisRepositoryState() {
    }

    public RedisRepositoryState(String state) {
        this.state = state;
    }

    public RedisRepositoryState(String state, boolean initial) {
        this(null, state, initial);
    }

    public RedisRepositoryState(String machineId, String state, boolean initial) {
        this(machineId, null, state, initial);
    }

    public RedisRepositoryState(String machineId, RedisRepositoryState parentState, String state, boolean initial) {
        this(machineId, parentState, state, initial, null, null, null);
    }

    public RedisRepositoryState(String machineId, RedisRepositoryState parentState, String state, boolean initial, Set<RedisRepositoryAction> stateActions, Set<RedisRepositoryAction> entryActions, Set<RedisRepositoryAction> exitActions) {
        this.machineId = machineId == null ? "" : machineId;
        this.parentState = parentState;
        this.state = state;
        this.initial = initial;
        this.stateActions = stateActions;
        this.entryActions = entryActions;
        this.exitActions = exitActions;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public RedisRepositoryState getParentState() {
        return this.parentState;
    }

    public void setParentState(RedisRepositoryState parentState) {
        this.parentState = parentState;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public PseudoStateKind getKind() {
        return this.kind;
    }

    public void setKind(PseudoStateKind kind) {
        this.kind = kind;
    }

    public Boolean isInitial() {
        return this.initial;
    }

    public void setInitial(boolean initial) {
        this.initial = initial;
    }

    public RepositoryAction getInitialAction() {
        return this.initialAction;
    }

    public void setInitialAction(RedisRepositoryAction initialAction) {
        this.initialAction = initialAction;
    }

    public Set<RedisRepositoryAction> getStateActions() {
        return this.stateActions;
    }

    public void setStateActions(Set<RedisRepositoryAction> stateActions) {
        this.stateActions = stateActions;
    }

    public Set<RedisRepositoryAction> getEntryActions() {
        return this.entryActions;
    }

    public void setEntryActions(Set<RedisRepositoryAction> entryActions) {
        this.entryActions = entryActions;
    }

    public Set<RedisRepositoryAction> getExitActions() {
        return this.exitActions;
    }

    public void setExitActions(Set<RedisRepositoryAction> exitActions) {
        this.exitActions = exitActions;
    }

    public Set<String> getDeferredEvents() {
        return this.deferredEvents;
    }

    public void setDeferredEvents(Set<String> deferredEvents) {
        this.deferredEvents = deferredEvents;
    }

    public String getSubmachineId() {
        return this.submachineId;
    }

    public void setSubmachineId(String submachineId) {
        this.submachineId = submachineId;
    }

    public String toString() {
        return "RedisRepositoryState [id=" + this.id + ", machineId=" + this.machineId + ", state=" + this.state + ", region=" + this.region + ", initial=" + this.initial + ", kind=" + this.kind + ", submachineId=" + this.submachineId + ", parentState=" + (Object)((Object)this.parentState) + ", stateActions=" + this.stateActions + ", entryActions=" + this.entryActions + ", exitActions=" + this.exitActions + ", deferredEvents=" + this.deferredEvents + "]";
    }
}

