/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.data.mongodb;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Set;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Reference;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.statemachine.data.RepositoryTransition;
import org.springframework.statemachine.data.mongodb.MongoDbRepositoryAction;
import org.springframework.statemachine.data.mongodb.MongoDbRepositoryGuard;
import org.springframework.statemachine.data.mongodb.MongoDbRepositoryState;
import org.springframework.statemachine.transition.TransitionKind;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
@Document(collection="MongoDbRepositoryTransition")
public class MongoDbRepositoryTransition
extends RepositoryTransition {
    @Id
    private String id;
    private String machineId = "";
    @Reference
    private MongoDbRepositoryState source;
    @Reference
    private MongoDbRepositoryState target;
    private String event;
    private TransitionKind kind;
    @Reference
    private Set<MongoDbRepositoryAction> actions;
    @Reference
    private MongoDbRepositoryGuard guard;

    public MongoDbRepositoryTransition() {
        this(null, null, null);
    }

    public MongoDbRepositoryTransition(MongoDbRepositoryState source, MongoDbRepositoryState target, String event) {
        this(null, source, target, event);
    }

    public MongoDbRepositoryTransition(String machineId, MongoDbRepositoryState source, MongoDbRepositoryState target, String event) {
        this(machineId, source, target, event, null);
    }

    public MongoDbRepositoryTransition(String machineId, MongoDbRepositoryState source, MongoDbRepositoryState target, String event, Set<MongoDbRepositoryAction> actions) {
        this.machineId = machineId == null ? "" : machineId;
        this.source = source;
        this.target = target;
        this.event = event;
        this.actions = actions;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public MongoDbRepositoryState getSource() {
        return this.source;
    }

    public void setSource(MongoDbRepositoryState source) {
        this.source = source;
    }

    public MongoDbRepositoryState getTarget() {
        return this.target;
    }

    public void setTarget(MongoDbRepositoryState target) {
        this.target = target;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public Set<MongoDbRepositoryAction> getActions() {
        return this.actions;
    }

    public void setActions(Set<MongoDbRepositoryAction> actions) {
        this.actions = actions;
    }

    public MongoDbRepositoryGuard getGuard() {
        return this.guard;
    }

    public void setGuard(MongoDbRepositoryGuard guard) {
        this.guard = guard;
    }

    public TransitionKind getKind() {
        return this.kind;
    }

    public void setKind(TransitionKind kind) {
        this.kind = kind;
    }

    public String toString() {
        return "MongoDbRepositoryTransition [id=" + this.id + ", machineId=" + this.machineId + ", source=" + this.source + ", target=" + this.target + ", event=" + this.event + ", kind=" + this.kind + ", actions=" + this.actions + ", guard=" + this.guard + "]";
    }
}

