/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.data.mongodb;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Set;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Reference;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.statemachine.data.RepositoryAction;
import org.springframework.statemachine.data.RepositoryState;
import org.springframework.statemachine.data.mongodb.MongoDbRepositoryAction;
import org.springframework.statemachine.state.PseudoStateKind;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class)
@Document(collection="MongoDbRepositoryState")
public class MongoDbRepositoryState
extends RepositoryState {
    @Id
    private String id;
    private String machineId = "";
    private String state;
    private String region;
    private boolean initial;
    private PseudoStateKind kind;
    private String submachineId;
    @Reference
    private MongoDbRepositoryState parentState;
    @Reference
    private MongoDbRepositoryAction initialAction;
    @Reference
    private Set<MongoDbRepositoryAction> stateActions;
    @Reference
    private Set<MongoDbRepositoryAction> entryActions;
    @Reference
    private Set<MongoDbRepositoryAction> exitActions;
    private Set<String> deferredEvents;

    public MongoDbRepositoryState() {
    }

    public MongoDbRepositoryState(String state) {
        this.state = state;
    }

    public MongoDbRepositoryState(String state, boolean initial) {
        this(null, state, initial);
    }

    public MongoDbRepositoryState(String machineId, String state, boolean initial) {
        this(machineId, null, state, initial);
    }

    public MongoDbRepositoryState(String machineId, MongoDbRepositoryState parentState, String state, boolean initial) {
        this(machineId, parentState, state, initial, null, null, null);
    }

    public MongoDbRepositoryState(String machineId, MongoDbRepositoryState parentState, String state, boolean initial, Set<MongoDbRepositoryAction> stateActions, Set<MongoDbRepositoryAction> entryActions, Set<MongoDbRepositoryAction> exitActions) {
        this.machineId = machineId == null ? "" : machineId;
        this.parentState = parentState;
        this.state = state;
        this.initial = initial;
        this.stateActions = stateActions;
        this.entryActions = entryActions;
        this.exitActions = exitActions;
    }

    public String getMachineId() {
        return this.machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public MongoDbRepositoryState getParentState() {
        return this.parentState;
    }

    public void setParentState(MongoDbRepositoryState parentState) {
        this.parentState = parentState;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public PseudoStateKind getKind() {
        return this.kind;
    }

    public void setKind(PseudoStateKind kind) {
        this.kind = kind;
    }

    public Boolean isInitial() {
        return this.initial;
    }

    public void setInitial(boolean initial) {
        this.initial = initial;
    }

    public RepositoryAction getInitialAction() {
        return this.initialAction;
    }

    public void setInitialAction(MongoDbRepositoryAction initialAction) {
        this.initialAction = initialAction;
    }

    public Set<MongoDbRepositoryAction> getStateActions() {
        return this.stateActions;
    }

    public void setStateActions(Set<MongoDbRepositoryAction> stateActions) {
        this.stateActions = stateActions;
    }

    public Set<MongoDbRepositoryAction> getEntryActions() {
        return this.entryActions;
    }

    public void setEntryActions(Set<MongoDbRepositoryAction> entryActions) {
        this.entryActions = entryActions;
    }

    public Set<MongoDbRepositoryAction> getExitActions() {
        return this.exitActions;
    }

    public void setExitActions(Set<MongoDbRepositoryAction> exitActions) {
        this.exitActions = exitActions;
    }

    public Set<String> getDeferredEvents() {
        return this.deferredEvents;
    }

    public void setDeferredEvents(Set<String> deferredEvents) {
        this.deferredEvents = deferredEvents;
    }

    public String getSubmachineId() {
        return this.submachineId;
    }

    public void setSubmachineId(String submachineId) {
        this.submachineId = submachineId;
    }

    public String toString() {
        return "MongoDbRepositoryState [id=" + this.id + ", machineId=" + this.machineId + ", state=" + this.state + ", region=" + this.region + ", initial=" + this.initial + ", kind=" + this.kind + ", submachineId=" + this.submachineId + ", parentState=" + (Object)((Object)this.parentState) + ", stateActions=" + this.stateActions + ", entryActions=" + this.entryActions + ", exitActions=" + this.exitActions + ", deferredEvents=" + this.deferredEvents + "]";
    }
}

