/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.data;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.data.RepositoryStateMachine;
import org.springframework.statemachine.data.StateMachineRepository;
import org.springframework.statemachine.kryo.KryoStateMachineSerialisationService;
import org.springframework.statemachine.service.StateMachineSerialisationService;
import org.springframework.util.Assert;

public abstract class RepositoryStateMachinePersist<M extends RepositoryStateMachine, S, E>
implements StateMachinePersist<S, E, Object> {
    private final Log log = LogFactory.getLog(RepositoryStateMachinePersist.class);
    private final StateMachineSerialisationService<S, E> serialisationService;

    protected RepositoryStateMachinePersist() {
        this.serialisationService = new KryoStateMachineSerialisationService();
    }

    protected RepositoryStateMachinePersist(StateMachineSerialisationService<S, E> serialisationService) {
        Assert.notNull(serialisationService, (String)"'serialisationService' must be set");
        this.serialisationService = serialisationService;
    }

    public void write(StateMachineContext<S, E> context, Object contextObj) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Persisting context " + context + " using contextObj " + contextObj));
        }
        M build = this.build(context, contextObj, this.serialisationService.serialiseStateMachineContext(context));
        this.getRepository().save(build);
    }

    public StateMachineContext<S, E> read(Object contextObj) throws Exception {
        RepositoryStateMachine repositoryStateMachine = this.getRepository().findById(contextObj.toString()).orElse(null);
        if (repositoryStateMachine != null) {
            return this.serialisationService.deserialiseStateMachineContext(repositoryStateMachine.getStateMachineContext());
        }
        return null;
    }

    protected abstract StateMachineRepository<M> getRepository();

    protected abstract M build(StateMachineContext<S, E> var1, Object var2, byte[] var3);
}

