/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.boot.support;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.boot.actuate.StateMachineTraceRepository;
import org.springframework.statemachine.monitor.AbstractStateMachineMonitor;
import org.springframework.statemachine.state.State;
import org.springframework.statemachine.transition.Transition;
import org.springframework.util.ObjectUtils;

public class BootStateMachineMonitor<S, E>
extends AbstractStateMachineMonitor<S, E> {
    private final StateMachineTraceRepository traceRepository;
    private final MeterRegistry meterRegistry;

    public BootStateMachineMonitor(MeterRegistry meterRegistry, StateMachineTraceRepository stateMachineTraceRepository) {
        this.meterRegistry = meterRegistry;
        this.traceRepository = stateMachineTraceRepository;
    }

    public void transition(StateMachine<S, E> stateMachine, Transition<S, E> transition, long duration) {
        this.getTransitionCounterBuilder(transition).register(this.meterRegistry).increment();
        this.getTransitionTimerBuilder(transition).register(this.meterRegistry).record(duration, TimeUnit.MILLISECONDS);
        HashMap<String, Object> traceInfo = new HashMap<String, Object>();
        traceInfo.put("transition", BootStateMachineMonitor.transitionToName(transition));
        traceInfo.put("duration", duration);
        traceInfo.put("machine", stateMachine.getId());
        this.traceRepository.add(traceInfo);
    }

    public void action(StateMachine<S, E> stateMachine, Action<S, E> action, long duration) {
        String actionName = BootStateMachineMonitor.actionToName(action);
        this.getActionCounterBuilder(action).register(this.meterRegistry).increment();
        this.getActionTimerBuilder(action).register(this.meterRegistry).record(duration, TimeUnit.MILLISECONDS);
        HashMap<String, Object> traceInfo = new HashMap<String, Object>();
        traceInfo.put("action", actionName);
        traceInfo.put("duration", duration);
        traceInfo.put("machine", stateMachine.getId());
        this.traceRepository.add(traceInfo);
    }

    private Counter.Builder getTransitionCounterBuilder(Transition<S, E> transition) {
        String transitionName = BootStateMachineMonitor.transitionToName(transition);
        Counter.Builder builder = Counter.builder((String)"ssm.transition.transit").tags(new String[]{"transitionName", transitionName}).description("Counter of Transition");
        return builder;
    }

    private Timer.Builder getTransitionTimerBuilder(Transition<S, E> transition) {
        String transitionName = BootStateMachineMonitor.transitionToName(transition);
        Timer.Builder builder = Timer.builder((String)"ssm.transition.duration").tags(new String[]{"transitionName", transitionName}).description("Timer of Transition");
        builder.publishPercentileHistogram();
        return builder;
    }

    private Counter.Builder getActionCounterBuilder(Action<S, E> action) {
        String actionName = BootStateMachineMonitor.actionToName(action);
        Counter.Builder builder = Counter.builder((String)"ssm.action.execute").tags(new String[]{"actionName", actionName}).description("Counter of Action");
        return builder;
    }

    private Timer.Builder getActionTimerBuilder(Action<S, E> action) {
        String actionName = BootStateMachineMonitor.actionToName(action);
        Timer.Builder builder = Timer.builder((String)"ssm.action.duration").tags(new String[]{"actionName", actionName}).description("Timer of Action");
        builder.publishPercentileHistogram();
        return builder;
    }

    private static <S, E> String transitionToName(Transition<S, E> transition) {
        String sourceId = BootStateMachineMonitor.nullStateId(transition.getSource());
        String targetId = BootStateMachineMonitor.nullStateId(transition.getTarget());
        StringBuilder buf = new StringBuilder();
        buf.append(transition.getKind());
        if (sourceId != null) {
            buf.append("_");
            buf.append(sourceId);
        }
        if (targetId != null) {
            buf.append("_");
            buf.append(targetId);
        }
        return buf.toString();
    }

    private static <S, E> String actionToName(Action<S, E> action) {
        return ObjectUtils.getDisplayString(action);
    }

    private static <S, E> String nullStateId(State<S, E> state) {
        if (state == null) {
            return null;
        }
        Object id = state.getId();
        return id != null ? id.toString() : null;
    }
}

