/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.ri;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springsource.loaded.ri.ReflectiveInterceptor;
import sl.org.objectweb.asm.Type;

public class Exceptions {
    static IllegalAccessException illegalSetFinalFieldException(Field field, Class<?> valueType, Object value) {
        String fieldType = field.getType().getName();
        String fieldQName = field.getDeclaringClass().getName() + "." + field.getName();
        String valueString = value == null ? "null value" : (valueType.isPrimitive() ? "(" + valueType.getName() + ")" + value : (value == null ? "null value" : value.getClass().getName()));
        return new IllegalAccessException("Can not set final " + fieldType + " field " + fieldQName + " to " + valueString);
    }

    static IllegalArgumentException illegalSetFieldTypeException(Field field, Class<?> valueType, Object value) {
        int mods = field.getModifiers() & 0x18;
        String modStr = Modifier.toString(mods);
        if (!modStr.equals("")) {
            modStr = modStr + " ";
        }
        String fieldType = field.getType().getName();
        String fieldQName = field.getDeclaringClass().getName() + "." + field.getName();
        String valueStr = valueType == null ? "null value" : (valueType.isPrimitive() ? "(" + valueType.getName() + ")" + value : valueType.getName());
        return new IllegalArgumentException("Can not set " + modStr + fieldType + " field " + fieldQName + " to " + valueStr);
    }

    public static NoSuchFieldError noSuchFieldError(Field field) {
        return new NoSuchFieldError(field.getName());
    }

    public static NoSuchMethodError noSuchMethodError(Method method) {
        return Exceptions.noSuchMethodError(method.getDeclaringClass().getName(), method.getName(), Type.getMethodDescriptor(method));
    }

    public static NoSuchMethodError noSuchMethodError(String dottedClassName, String methodName, String methodDescriptor) {
        return new NoSuchMethodError(dottedClassName + "." + methodName + methodDescriptor);
    }

    static NoSuchMethodException noSuchMethodException(Class<?> clazz, String name, Class<?> ... params) {
        return new NoSuchMethodException(clazz.getName() + "." + name + ReflectiveInterceptor.toParamString(params));
    }

    static NoSuchFieldException noSuchFieldException(String name) {
        return new NoSuchFieldException(name);
    }

    public static IllegalArgumentException illegalGetFieldType(Field field, Class<?> returnType) {
        String fieldQName = field.getDeclaringClass().getName() + "." + field.getName();
        String returnTypeName = returnType.getName();
        String fieldType = field.getType().getName();
        return new IllegalArgumentException("Attempt to get " + fieldType + " field \"" + fieldQName + "\" with illegal data type conversion to " + returnTypeName);
    }

    public static NoSuchMethodException noSuchConstructorException(Class<?> clazz, Class<?>[] params) {
        return Exceptions.noSuchMethodException(clazz, "<init>", params);
    }

    public static NoSuchMethodError noSuchConstructorError(Constructor<?> c) {
        return new NoSuchMethodError(c.getDeclaringClass().getName() + ".<init>" + Type.getConstructorDescriptor(c));
    }

    public static InstantiationException instantiation(Class<?> clazz) {
        return new InstantiationException(clazz.getName());
    }
}

