/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded.jvm;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.ri.ReflectiveInterceptor;
import sun.reflect.Reflection;

public class JVM {
    public static Logger log = Logger.getLogger(JVM.class.getName());
    private static Constructor<Method> jlrMethodCtor = Method.class.getDeclaredConstructors()[0];
    private static Method jlrMethodCopy;
    private static Method jlrFieldCopy;
    private static Method jlrConstructorCopy;
    private static Field jlrMethodModifiers;
    private static Field jlrConstructorModifiers;
    private static Field jlrFieldModifiers;
    private static final Constructor<Field> jlFieldCtor;
    private static final Constructor<Constructor<?>> jlConstructorCtor;

    public static void ensureMemberAccess(Class<?> callerClass, Class<?> declaringClass, Object target, int mods) throws IllegalAccessException {
        Reflection.ensureMemberAccess(callerClass, declaringClass, (Object)target, (int)mods);
    }

    public static Method newMethod(Class<?> clazz, String name, Class<?>[] params, Class<?> returnType, Class<?>[] exceptions, int modifiers, String signature) {
        Method returnMethod;
        try {
            jlrMethodCtor.setAccessible(true);
            returnMethod = jlrMethodCtor.newInstance(clazz, name, params, returnType, exceptions, modifiers, 0, signature, null, null, null);
        }
        catch (Exception e) {
            ReflectiveInterceptor.log.log(Level.SEVERE, "Internal Error", e);
            throw new Error(e);
        }
        return returnMethod;
    }

    public static Method copyMethod(Method method) {
        try {
            return (Method)jlrMethodCopy.invoke((Object)method, new Object[0]);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problems copying method. Incompatible JVM?", e);
            return method;
        }
    }

    public static Field copyField(Field field) {
        try {
            return (Field)jlrFieldCopy.invoke((Object)field, new Object[0]);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problems copying field. Incompatible JVM?", e);
            return field;
        }
    }

    public static Constructor<?> copyConstructor(Constructor<?> c) {
        try {
            return (Constructor)jlrConstructorCopy.invoke(c, new Object[0]);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problems copying constructor. Incompatible JVM?", e);
            return c;
        }
    }

    public static void setMethodModifiers(Method method, int modifiers) {
        try {
            jlrMethodModifiers.setInt(method, modifiers);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Couldn't set correct modifiers on reflected method: " + method, e);
        }
    }

    public static void setConstructorModifiers(Constructor<?> c, int modifiers) {
        try {
            jlrConstructorModifiers.setInt(c, modifiers);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Couldn't set correct modifiers on reflected constructor: " + c, e);
        }
    }

    public static void setFieldModifiers(Field field, int mods) {
        try {
            jlrFieldModifiers.setInt(field, mods);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Couldn't set correct modifiers on reflected field: " + field, e);
        }
    }

    public static Field newField(Class<?> declaring, Class<?> type, int mods, String name, String sig) {
        jlFieldCtor.setAccessible(true);
        try {
            return jlFieldCtor.newInstance(declaring, name, type, mods, 0, sig, null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem creating reloadable Field: " + declaring.getName() + "." + name, e);
        }
    }

    public static Constructor<?> newConstructor(Class<?> clazz, Class<?>[] params, Class<?>[] exceptions, int modifiers, String signature) {
        jlConstructorCtor.setAccessible(true);
        try {
            return jlConstructorCtor.newInstance(clazz, params, exceptions, modifiers, 0, signature, null, null);
        }
        catch (Exception e) {
            StringBuffer msg = new StringBuffer("Problem creating reloadable Constructor: ");
            msg.append(clazz.getName());
            msg.append("(");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(params[i].getName());
            }
            msg.append(")");
            throw new IllegalStateException(msg.toString(), e);
        }
    }

    static {
        try {
            jlrMethodCopy = Method.class.getDeclaredMethod("copy", new Class[0]);
            jlrMethodCopy.setAccessible(true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problems getting 'Method.copy()' method. Incompatible JVM?", e);
        }
        try {
            jlrFieldCopy = Field.class.getDeclaredMethod("copy", new Class[0]);
            jlrFieldCopy.setAccessible(true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problems getting 'Field.copy()' method. Incompatible JVM?", e);
        }
        try {
            jlrConstructorCopy = Constructor.class.getDeclaredMethod("copy", new Class[0]);
            jlrConstructorCopy.setAccessible(true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problems getting 'Constructor.copy()' method. Incompatible JVM?", e);
        }
        try {
            jlrMethodModifiers = Method.class.getDeclaredField("modifiers");
            jlrMethodModifiers.setAccessible(true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problems getting Field 'Method.modifiers' method. Incompatible JVM?", e);
        }
        try {
            jlrConstructorModifiers = Constructor.class.getDeclaredField("modifiers");
            jlrConstructorModifiers.setAccessible(true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problems getting Field 'Constructor.modifiers' method. Incompatible JVM?", e);
        }
        try {
            jlrFieldModifiers = Field.class.getDeclaredField("modifiers");
            jlrFieldModifiers.setAccessible(true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Problems getting Field 'Field.modifiers' method. Incompatible JVM?", e);
        }
        jlFieldCtor = Field.class.getDeclaredConstructors()[0];
        jlConstructorCtor = Constructor.class.getDeclaredConstructors()[0];
    }
}

