/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.springsource.loaded.IsReloadableTypePlugin;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.TypeRegistry;
import org.springsource.loaded.agent.ReloadDecision;

public class SystemPropertyConfiguredIsReloadableTypePlugin
implements IsReloadableTypePlugin {
    public static final boolean debug;
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();
    private String mostRecentReloadableDirs = null;

    public SystemPropertyConfiguredIsReloadableTypePlugin() {
        if (debug) {
            System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: instantiated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReloadDecision shouldBeMadeReloadable(TypeRegistry typeRegistry, String typename, ProtectionDomain protectionDomain, byte[] bytes) {
        block29: {
            CodeSource codeSource;
            if (debug) {
                System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: entered, for typename " + typename);
            }
            if (protectionDomain == null) {
                return ReloadDecision.PASS;
            }
            String reloadableDirs = System.getProperty("springloaded.directoriesContainingReloadableCode");
            if (debug) {
                System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: reloadableDirs=" + reloadableDirs);
            }
            if (reloadableDirs == null) {
                return ReloadDecision.PASS;
            }
            if (this.mostRecentReloadableDirs != reloadableDirs) {
                List<String> list = this.includes;
                synchronized (list) {
                    if (this.mostRecentReloadableDirs != reloadableDirs) {
                        this.includes.clear();
                        this.excludes.clear();
                        StringTokenizer st = new StringTokenizer(reloadableDirs, ",");
                        while (st.hasMoreTokens()) {
                            boolean isNot;
                            String nextDir = st.nextToken();
                            boolean bl = isNot = nextDir.charAt(0) == '!';
                            if (isNot) {
                                this.excludes.add(nextDir.substring(1));
                                continue;
                            }
                            this.includes.add(nextDir);
                        }
                        this.mostRecentReloadableDirs = reloadableDirs;
                    }
                }
            }
            if ((codeSource = protectionDomain.getCodeSource()) == null || codeSource.getLocation() == null) {
                return ReloadDecision.NO;
            }
            int cglibIndex = typename.indexOf("ByCGLIB$$");
            if (cglibIndex != -1) {
                String originalType = typename.substring(0, typename.indexOf("$$"));
                while (typeRegistry != null) {
                    ReloadableType originalReloadable = typeRegistry.getReloadableType(originalType);
                    if (originalReloadable != null) {
                        return ReloadDecision.YES;
                    }
                    typeRegistry = typeRegistry.getParentRegistry();
                }
            }
            if (debug) {
                System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: " + typename + " codeSource.getLocation() is " + codeSource.getLocation());
            }
            try {
                URI uri = codeSource.getLocation().toURI();
                File file = new File(uri);
                String path = file.toString();
                List<String> list = this.includes;
                synchronized (list) {
                    for (String exclude : this.excludes) {
                        if (!path.contains(exclude)) continue;
                        if (debug) {
                            System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: " + typename + " is not being made reloadable");
                        }
                        return ReloadDecision.NO;
                    }
                    for (String include : this.includes) {
                        if (!path.contains(include)) continue;
                        if (debug) {
                            System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: " + typename + " is being made reloadable");
                        }
                        return ReloadDecision.YES;
                    }
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException iae) {
                if (!debug) break block29;
                try {
                    System.out.println("IllegalArgumentException: URI is not hierarchical, uri is " + codeSource.getLocation().toURI());
                }
                catch (URISyntaxException use) {
                    System.out.println("IllegalArgumentException: URI is not hierarchical, uri is " + codeSource.getLocation());
                }
            }
        }
        if (debug) {
            System.out.println("SystemPropertyConfiguredIsReloadableTypePlugin: " + typename + " is being PASSed on");
        }
        return ReloadDecision.PASS;
    }

    static {
        boolean value = false;
        try {
            value = System.getProperty("springloaded.directoriesContainingReloadableCode.debug", "false").equalsIgnoreCase("true");
        }
        catch (Exception exception) {
            // empty catch block
        }
        debug = value;
    }
}

