/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.Constants;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.MethodInvokerRewriter;
import org.springsource.loaded.SystemClassReflectionGenerator;
import sl.org.objectweb.asm.ClassAdapter;
import sl.org.objectweb.asm.ClassReader;
import sl.org.objectweb.asm.ClassWriter;
import sl.org.objectweb.asm.MethodAdapter;
import sl.org.objectweb.asm.MethodVisitor;
import sl.org.objectweb.asm.Opcodes;

public class SystemClassReflectionRewriter {
    private static Logger log = Logger.getLogger(SystemClassReflectionRewriter.class.getName());

    public static RewriteResult rewrite(String slashedClassName, byte[] bytes) {
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.INFO)) {
            log.info("SystemClassReflectionRewriter running for " + slashedClassName);
        }
        ClassReader fileReader = new ClassReader(bytes);
        RewriteClassAdaptor classAdaptor = new RewriteClassAdaptor();
        fileReader.accept(classAdaptor, 4);
        return new RewriteResult(classAdaptor.getBytes(), classAdaptor.getBits());
    }

    static class RewriteClassAdaptor
    extends ClassAdapter
    implements Constants {
        private ClassWriter cw = (ClassWriter)this.cv;
        int bits = 0;
        private String classname;

        private static boolean isInterceptable(String owner, String methodName) {
            String s = owner + "." + methodName;
            return MethodInvokerRewriter.RewriteClassAdaptor.intercepted.contains(s);
        }

        public RewriteClassAdaptor() {
            super(new ClassWriter(1));
        }

        public byte[] getBytes() {
            byte[] bytes = this.cw.toByteArray();
            return bytes;
        }

        public int getBits() {
            return this.bits;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.classname = name;
        }

        @Override
        public MethodVisitor visitMethod(int flags, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(flags, name, descriptor, signature, exceptions);
            return new RewritingMethodAdapter(mv);
        }

        @Override
        public void visitEnd() {
            this.addExtraMethodsAndFields();
            super.visitEnd();
        }

        private void addExtraMethodsAndFields() {
            if ((this.bits & 1) != 0) {
                SystemClassReflectionGenerator.generateJLCGDFS(this.cw, this.classname);
            }
            if ((this.bits & 2) != 0) {
                SystemClassReflectionGenerator.generateJLC(this.cw, this.classname, "getDeclaredField");
            }
            if ((this.bits & 4) != 0) {
                SystemClassReflectionGenerator.generateJLC(this.cw, this.classname, "getField");
            }
            if ((this.bits & 8) != 0) {
                SystemClassReflectionGenerator.generateJLCGetXXXMethods(this.cw, this.classname, "getDeclaredMethods");
            }
            if ((this.bits & 0x10) != 0) {
                SystemClassReflectionGenerator.generateJLCMethod(this.cw, this.classname, "getDeclaredMethod");
            }
            if ((this.bits & 0x20) != 0) {
                SystemClassReflectionGenerator.generateJLCMethod(this.cw, this.classname, "getMethod");
            }
            if ((this.bits & 0x80) != 0) {
                SystemClassReflectionGenerator.generateJLCGMODS(this.cw, this.classname);
            }
            if ((this.bits & 0x40) != 0) {
                SystemClassReflectionGenerator.generateJLCGDC(this.cw, this.classname);
            }
            if ((this.bits & 0x100) != 0) {
                SystemClassReflectionGenerator.generateJLCGetXXXMethods(this.cw, this.classname, "getMethods");
            }
            if ((this.bits & 0x200) != 0) {
                SystemClassReflectionGenerator.generateJLCGC(this.cw, this.classname);
            }
        }

        class RewritingMethodAdapter
        extends MethodAdapter
        implements Opcodes,
        Constants {
            int unitializedObjectsCount;

            public RewritingMethodAdapter(MethodVisitor mv) {
                super(mv);
                this.unitializedObjectsCount = 0;
            }

            private boolean interceptReflection(String owner, String name, String desc) {
                if (RewriteClassAdaptor.isInterceptable(owner, name)) {
                    return this.callReflectiveInterceptor(owner, name, desc, this.mv);
                }
                return false;
            }

            @Override
            public void visitTypeInsn(int opcode, String type) {
                if (opcode == 187) {
                    ++this.unitializedObjectsCount;
                }
                super.visitTypeInsn(opcode, type);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (this.rewriteReflectiveCall(opcode, owner, name, desc)) {
                    return;
                }
                if (opcode == 183) {
                    --this.unitializedObjectsCount;
                }
                super.visitMethodInsn(opcode, owner, name, desc);
            }

            private boolean rewriteReflectiveCall(int opcode, String owner, String name, String desc) {
                boolean rewritten;
                return owner.length() > 10 && owner.charAt(8) == 'g' && (owner.startsWith("java/lang/reflect/") || owner.equals("java/lang/Class")) && (rewritten = this.interceptReflection(owner, name, desc));
            }

            private boolean callReflectiveInterceptor(String owner, String name, String desc, MethodVisitor mv) {
                if (owner.equals("java/lang/Class")) {
                    if (name.equals("getDeclaredFields")) {
                        RewriteClassAdaptor.this.bits |= 1;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgdfs", "(Ljava/lang/Class;)[Ljava/lang/reflect/Field;");
                        return true;
                    }
                    if (name.equals("getDeclaredField")) {
                        RewriteClassAdaptor.this.bits |= 2;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgdf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/reflect/Field;");
                        return true;
                    }
                    if (name.equals("getField")) {
                        RewriteClassAdaptor.this.bits |= 4;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/reflect/Field;");
                        return true;
                    }
                    if (name.equals("getDeclaredMethods")) {
                        RewriteClassAdaptor.this.bits |= 8;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgdms", "(Ljava/lang/Class;)[Ljava/lang/reflect/Method;");
                        return true;
                    }
                    if (name.equals("getDeclaredMethod")) {
                        RewriteClassAdaptor.this.bits |= 0x10;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgdm", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
                        return true;
                    }
                    if (name.equals("getMethod")) {
                        RewriteClassAdaptor.this.bits |= 0x20;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgm", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;");
                        return true;
                    }
                    if (name.equals("getDeclaredConstructor")) {
                        RewriteClassAdaptor.this.bits |= 0x40;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgdc", "(Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/reflect/Constructor;");
                        return true;
                    }
                    if (name.equals("getConstructor")) {
                        RewriteClassAdaptor.this.bits |= 0x200;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgc", "(Ljava/lang/Class;[Ljava/lang/Class;)Ljava/lang/reflect/Constructor;");
                        return true;
                    }
                    if (name.equals("getModifiers")) {
                        RewriteClassAdaptor.this.bits |= 0x80;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgmods", "(Ljava/lang/Class;)I");
                        return true;
                    }
                    if (name.equals("getMethods")) {
                        RewriteClassAdaptor.this.bits |= 0x100;
                        mv.visitMethodInsn(184, RewriteClassAdaptor.this.classname, "__sljlcgms", "(Ljava/lang/Class;)[Ljava/lang/reflect/Method;");
                        return true;
                    }
                    if (name.equals("newInstance")) {
                        return false;
                    }
                } else if (owner.equals("java/lang/reflect/Constructor") && name.equals("newInstance")) {
                    return false;
                }
                System.err.println("!!! SystemClassReflectionRewriter: nyi for " + owner + "." + name);
                return false;
            }
        }
    }

    public static class RewriteResult
    implements Constants {
        public final byte[] bytes;
        public final int bits;

        public RewriteResult(byte[] bytes, int bits) {
            this.bytes = bytes;
            this.bits = bits;
        }

        public String summarize() {
            StringBuilder s = new StringBuilder();
            s.append((this.bits & 0x40) != 0 ? "getDeclaredConstructor()" : "");
            s.append((this.bits & 0x200) != 0 ? "getConstructor()" : "");
            s.append((this.bits & 0x80) != 0 ? "getModifiers()" : "");
            s.append((this.bits & 1) != 0 ? "getDeclaredFields() " : "");
            s.append((this.bits & 2) != 0 ? "getDeclaredField() " : "");
            s.append((this.bits & 4) != 0 ? "getField() " : "");
            s.append((this.bits & 8) != 0 ? "getDeclaredMethods() " : "");
            s.append((this.bits & 0x10) != 0 ? "getDeclaredMethod() " : "");
            s.append((this.bits & 0x20) != 0 ? "getMethod() " : "");
            s.append((this.bits & 0x100) != 0 ? "getMethods() " : "");
            return s.toString().trim();
        }
    }
}

