/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springsource.loaded.FieldMember;
import org.springsource.loaded.FieldReaderWriter;
import org.springsource.loaded.GlobalConfiguration;
import org.springsource.loaded.ReloadableType;
import org.springsource.loaded.Utils;

public class SSMgr {
    private static Logger log = Logger.getLogger(SSMgr.class.getName());
    Map<String, Map<String, Object>> values = new HashMap<String, Map<String, Object>>();

    public Object getValue(ReloadableType rtype, String name) throws IllegalAccessException {
        Object result = null;
        FieldMember fieldmember = rtype.findStaticField(name);
        if (fieldmember == null) {
            FieldReaderWriter flr = rtype.locateField(name);
            if (flr == null) {
                log.info("Unexpectedly unable to locate static field " + name + " starting from type " + rtype.dottedtypename + ": clinit running late?");
                return null;
            }
            result = flr.getStaticFieldValue(rtype.getClazz(), this);
        } else {
            if (!fieldmember.isStatic()) {
                throw new IncompatibleClassChangeError("Expected static field " + rtype.dottedtypename + "." + fieldmember.getName());
            }
            String declaringTypeName = fieldmember.getDeclaringTypeName();
            Map<String, Object> typeLevelValues = this.values.get(declaringTypeName);
            boolean knownField = false;
            if (typeLevelValues != null) {
                knownField = typeLevelValues.containsKey(name);
            }
            if (knownField) {
                result = typeLevelValues.get(name);
            }
            if (typeLevelValues == null || !knownField) {
                FieldMember fieldOnOriginalType = rtype.getTypeRegistry().getReloadableType(declaringTypeName).getTypeDescriptor().getField(name);
                if (fieldOnOriginalType != null) {
                    ReloadableType rt = rtype.getTypeRegistry().getReloadableType(fieldmember.getDeclaringTypeName());
                    try {
                        Field f = rt.getClazz().getDeclaredField(name);
                        f.setAccessible(true);
                        result = f.get(null);
                        if (typeLevelValues == null) {
                            typeLevelValues = new HashMap<String, Object>();
                            this.values.put(declaringTypeName, typeLevelValues);
                        }
                        typeLevelValues.put(name, result);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unexpectedly unable to access field " + name + " on type " + rt.getClazz().getName(), e);
                    }
                } else {
                    result = Utils.toResultCheckIfNull(null, fieldmember.getDescriptor());
                    if (typeLevelValues == null) {
                        typeLevelValues = new HashMap<String, Object>();
                        this.values.put(declaringTypeName, typeLevelValues);
                    }
                    typeLevelValues.put(name, result);
                    return result;
                }
            }
            if (result != null && (result = Utils.checkCompatibility(rtype.getTypeRegistry(), result, fieldmember.getDescriptor())) == null) {
                typeLevelValues.remove(fieldmember.getName());
            }
            result = Utils.toResultCheckIfNull(result, fieldmember.getDescriptor());
        }
        return result;
    }

    public void setValue(ReloadableType rtype, Object newValue, String name) throws IllegalAccessException {
        FieldMember fieldmember;
        if (GlobalConfiguration.isRuntimeLogging && log.isLoggable(Level.FINEST)) {
            log.finest("Static field set: " + rtype.getName() + "." + name + " " + newValue);
        }
        if ((fieldmember = rtype.findStaticField(name)) == null) {
            FieldReaderWriter frw = rtype.locateField(name);
            if (frw == null) {
                log.info("Unexpectedly unable to locate static field " + name + " starting from type " + rtype.dottedtypename + ": clinit running late?");
                return;
            }
            frw.setStaticFieldValue(rtype.getClazz(), newValue, this);
        } else {
            if (!fieldmember.isStatic()) {
                throw new IncompatibleClassChangeError("Expected static field " + rtype.dottedtypename + "." + fieldmember.getName());
            }
            Map<String, Object> typeValues = this.values.get(fieldmember.getDeclaringTypeName());
            if (typeValues == null) {
                typeValues = new HashMap<String, Object>();
                this.values.put(fieldmember.getDeclaringTypeName(), typeValues);
            }
            typeValues.put(name, newValue);
        }
    }

    private String valuesToString() {
        StringBuilder s = new StringBuilder();
        s.append("FieldAccessor:" + System.identityHashCode(this)).append("\n");
        for (Map.Entry<String, Map<String, Object>> entry : this.values.entrySet()) {
            s.append("Type " + entry.getKey()).append("\n");
            for (Map.Entry<String, Object> entry2 : entry.getValue().entrySet()) {
                s.append(" " + entry2.getKey() + "=" + entry2.getValue()).append("\n");
            }
        }
        return s.toString();
    }

    public String toString() {
        return this.valuesToString();
    }

    Map<String, Map<String, Object>> getMap() {
        return this.values;
    }
}

