/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.reactive.resource.ResourceUrlProvider;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class ResourceTransformerSupport
implements ResourceTransformer {
    private @Nullable ResourceUrlProvider resourceUrlProvider;

    public void setResourceUrlProvider(@Nullable ResourceUrlProvider resourceUrlProvider) {
        this.resourceUrlProvider = resourceUrlProvider;
    }

    public @Nullable ResourceUrlProvider getResourceUrlProvider() {
        return this.resourceUrlProvider;
    }

    protected Mono<String> resolveUrlPath(String resourcePath, ServerWebExchange exchange2, Resource resource, ResourceTransformerChain transformerChain) {
        if (resourcePath.startsWith("/")) {
            ResourceUrlProvider urlProvider = this.getResourceUrlProvider();
            return urlProvider != null ? urlProvider.getForUriString(resourcePath, exchange2) : Mono.empty();
        }
        return transformerChain.getResolverChain().resolveUrlPath(resourcePath, Collections.singletonList(resource));
    }

    protected String toAbsolutePath(String path, ServerWebExchange exchange2) {
        String requestPath = exchange2.getRequest().getURI().getPath();
        String absolutePath = path.startsWith("/") ? path : StringUtils.applyRelativePath((String)requestPath, (String)path);
        return StringUtils.cleanPath((String)absolutePath);
    }
}

