/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.server.HandlerFilterFunction;
import org.springframework.web.reactive.function.server.HandlerFunction;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class RouterFunctionBuilder
implements RouterFunctions.Builder {
    private final List<RouterFunction<ServerResponse>> routerFunctions = new ArrayList<RouterFunction<ServerResponse>>();
    private final List<HandlerFilterFunction<ServerResponse, ServerResponse>> filterFunctions = new ArrayList<HandlerFilterFunction<ServerResponse, ServerResponse>>();
    private final List<HandlerFilterFunction<ServerResponse, ServerResponse>> errorHandlers = new ArrayList<HandlerFilterFunction<ServerResponse, ServerResponse>>();

    RouterFunctionBuilder() {
    }

    @Override
    public RouterFunctions.Builder add(RouterFunction<ServerResponse> routerFunction) {
        Assert.notNull(routerFunction, (String)"RouterFunction must not be null");
        this.routerFunctions.add(routerFunction);
        return this;
    }

    private RouterFunctions.Builder add(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        this.routerFunctions.add(RouterFunctions.route(predicate, handlerFunction));
        return this;
    }

    @Override
    public RouterFunctions.Builder GET(HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.GET), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder GET(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.GET).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder GET(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.GET(pattern), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder GET(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.GET(pattern).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder HEAD(HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.HEAD), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder HEAD(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.HEAD).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder HEAD(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.HEAD(pattern), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder HEAD(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.HEAD(pattern).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder POST(HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.POST), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder POST(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.POST).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder POST(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.POST(pattern), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder POST(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.POST(pattern).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder PUT(HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.PUT), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder PUT(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.PUT).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder PUT(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.PUT(pattern), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder PUT(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.PUT(pattern).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder PATCH(HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.PATCH), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder PATCH(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.PATCH).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder PATCH(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.PATCH(pattern), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder PATCH(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.PATCH(pattern).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder DELETE(HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.DELETE), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder DELETE(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.DELETE).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder DELETE(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.DELETE(pattern), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder DELETE(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.DELETE(pattern).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder OPTIONS(HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.OPTIONS), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder OPTIONS(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.method(HttpMethod.OPTIONS).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder OPTIONS(String pattern, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.OPTIONS(pattern), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder OPTIONS(String pattern, RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RequestPredicates.OPTIONS(pattern).and(predicate), handlerFunction);
    }

    @Override
    public RouterFunctions.Builder route(RequestPredicate predicate, HandlerFunction<ServerResponse> handlerFunction) {
        return this.add(RouterFunctions.route(predicate, handlerFunction));
    }

    @Override
    public RouterFunctions.Builder resource(RequestPredicate predicate, Resource resource) {
        return this.add(RouterFunctions.resource(predicate, resource));
    }

    @Override
    public RouterFunctions.Builder resource(RequestPredicate predicate, Resource resource, BiConsumer<Resource, HttpHeaders> headersConsumer) {
        return this.add(RouterFunctions.resource(predicate, resource, headersConsumer));
    }

    @Override
    public RouterFunctions.Builder resources(String pattern, Resource location) {
        return this.add(RouterFunctions.resources(pattern, location));
    }

    @Override
    public RouterFunctions.Builder resources(String pattern, Resource location, BiConsumer<Resource, HttpHeaders> headersConsumer) {
        return this.add(RouterFunctions.resources(pattern, location, headersConsumer));
    }

    @Override
    public RouterFunctions.Builder resources(Function<ServerRequest, Mono<Resource>> lookupFunction) {
        return this.add(RouterFunctions.resources(lookupFunction));
    }

    @Override
    public RouterFunctions.Builder resources(Function<ServerRequest, Mono<Resource>> lookupFunction, BiConsumer<Resource, HttpHeaders> headersConsumer) {
        return this.add(RouterFunctions.resources(lookupFunction, headersConsumer));
    }

    @Override
    public RouterFunctions.Builder nest(RequestPredicate predicate, Consumer<RouterFunctions.Builder> builderConsumer) {
        Assert.notNull(builderConsumer, (String)"Consumer must not be null");
        RouterFunctionBuilder nestedBuilder = new RouterFunctionBuilder();
        builderConsumer.accept(nestedBuilder);
        RouterFunction<ServerResponse> nestedRoute = nestedBuilder.build();
        this.routerFunctions.add(RouterFunctions.nest(predicate, nestedRoute));
        return this;
    }

    @Override
    public RouterFunctions.Builder nest(RequestPredicate predicate, Supplier<RouterFunction<ServerResponse>> routerFunctionSupplier) {
        Assert.notNull(routerFunctionSupplier, (String)"RouterFunction Supplier must not be null");
        RouterFunction<ServerResponse> nestedRoute = routerFunctionSupplier.get();
        this.routerFunctions.add(RouterFunctions.nest(predicate, nestedRoute));
        return this;
    }

    @Override
    public RouterFunctions.Builder path(String pattern, Consumer<RouterFunctions.Builder> builderConsumer) {
        return this.nest(RequestPredicates.path(pattern), builderConsumer);
    }

    @Override
    public RouterFunctions.Builder path(String pattern, Supplier<RouterFunction<ServerResponse>> routerFunctionSupplier) {
        return this.nest(RequestPredicates.path(pattern), routerFunctionSupplier);
    }

    @Override
    public RouterFunctions.Builder filter(HandlerFilterFunction<ServerResponse, ServerResponse> filterFunction) {
        Assert.notNull(filterFunction, (String)"HandlerFilterFunction must not be null");
        this.filterFunctions.add(filterFunction);
        return this;
    }

    @Override
    public RouterFunctions.Builder before(Function<ServerRequest, ServerRequest> requestProcessor) {
        Assert.notNull(requestProcessor, (String)"RequestProcessor must not be null");
        return this.filter((request, next) -> next.handle((ServerRequest)requestProcessor.apply(request)));
    }

    @Override
    public RouterFunctions.Builder after(BiFunction<ServerRequest, ServerResponse, ServerResponse> responseProcessor) {
        Assert.notNull(responseProcessor, (String)"ResponseProcessor must not be null");
        return this.filter((request, next) -> next.handle(request).map(serverResponse -> (ServerResponse)responseProcessor.apply(request, (ServerResponse)serverResponse)));
    }

    @Override
    public RouterFunctions.Builder onError(Predicate<? super Throwable> predicate, BiFunction<? super Throwable, ServerRequest, Mono<ServerResponse>> responseProvider) {
        Assert.notNull(predicate, (String)"Predicate must not be null");
        Assert.notNull(responseProvider, (String)"ResponseProvider must not be null");
        this.errorHandlers.add(0, (request, next) -> next.handle(request).onErrorResume(predicate, t -> (Mono)responseProvider.apply((Throwable)t, request)));
        return this;
    }

    @Override
    public <T extends Throwable> RouterFunctions.Builder onError(Class<T> exceptionType, BiFunction<? super T, ServerRequest, Mono<ServerResponse>> responseProvider) {
        Assert.notNull(exceptionType, (String)"ExceptionType must not be null");
        Assert.notNull(responseProvider, (String)"ResponseProvider must not be null");
        this.errorHandlers.add(0, (request, next) -> next.handle(request).onErrorResume(exceptionType, t -> (Mono)responseProvider.apply(t, request)));
        return this;
    }

    @Override
    public RouterFunctions.Builder withAttribute(String name, Object value) {
        Assert.hasLength((String)name, (String)"Name must not be empty");
        Assert.notNull((Object)value, (String)"Value must not be null");
        if (this.routerFunctions.isEmpty()) {
            throw new IllegalStateException("attributes can only be called after any other method (GET, path, etc.)");
        }
        int lastIdx = this.routerFunctions.size() - 1;
        RouterFunction<ServerResponse> attributed = this.routerFunctions.get(lastIdx).withAttribute(name, value);
        this.routerFunctions.set(lastIdx, attributed);
        return this;
    }

    @Override
    public RouterFunctions.Builder withAttributes(Consumer<Map<String, Object>> attributesConsumer) {
        Assert.notNull(attributesConsumer, (String)"AttributesConsumer must not be null");
        if (this.routerFunctions.isEmpty()) {
            throw new IllegalStateException("attributes can only be called after any other method (GET, path, etc.)");
        }
        int lastIdx = this.routerFunctions.size() - 1;
        RouterFunction<ServerResponse> attributed = this.routerFunctions.get(lastIdx).withAttributes(attributesConsumer);
        this.routerFunctions.set(lastIdx, attributed);
        return this;
    }

    @Override
    public RouterFunction<ServerResponse> build() {
        if (this.routerFunctions.isEmpty()) {
            throw new IllegalStateException("No routes registered. Register a route with GET(), POST(), etc.");
        }
        BuiltRouterFunction result = new BuiltRouterFunction(this.routerFunctions);
        if (this.filterFunctions.isEmpty() && this.errorHandlers.isEmpty()) {
            return result;
        }
        HandlerFilterFunction filter2 = (HandlerFilterFunction)Stream.concat(this.filterFunctions.stream(), this.errorHandlers.stream()).reduce(HandlerFilterFunction::andThen).orElseThrow(IllegalStateException::new);
        return result.filter(filter2);
    }

    private static class BuiltRouterFunction
    extends RouterFunctions.AbstractRouterFunction<ServerResponse> {
        private final List<RouterFunction<ServerResponse>> routerFunctions;

        public BuiltRouterFunction(List<RouterFunction<ServerResponse>> routerFunctions) {
            Assert.notEmpty(routerFunctions, (String)"RouterFunctions must not be empty");
            this.routerFunctions = new ArrayList<RouterFunction<ServerResponse>>(routerFunctions);
        }

        @Override
        public Mono<HandlerFunction<ServerResponse>> route(ServerRequest request) {
            return Flux.fromIterable(this.routerFunctions).concatMap(routerFunction -> routerFunction.route(request)).next();
        }

        @Override
        public void accept(RouterFunctions.Visitor visitor) {
            this.routerFunctions.forEach(routerFunction -> routerFunction.accept(visitor));
        }
    }
}

