/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result;

import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Mono;

public class SimpleHandlerAdapter
implements HandlerAdapter {
    private static final MethodParameter RETURN_TYPE;

    @Override
    public boolean supports(Object handler) {
        return WebHandler.class.isAssignableFrom(handler.getClass());
    }

    @Override
    public Mono<HandlerResult> handle(ServerWebExchange exchange, Object handler) {
        WebHandler webHandler = (WebHandler)handler;
        Mono mono = webHandler.handle(exchange);
        return mono.then(Mono.empty());
    }

    static {
        try {
            Method method2 = WebHandler.class.getMethod("handle", ServerWebExchange.class);
            RETURN_TYPE = new MethodParameter(method2, -1);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Failed to initialize the return type for WebHandler: " + ex.getMessage());
        }
    }
}

