/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyExtractor;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.DefaultWebClientBuilder;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultWebClient
implements WebClient {
    private static final Mono<ClientResponse> NO_HTTP_CLIENT_RESPONSE_ERROR = Mono.error((Throwable)new IllegalStateException("The underlying HTTP client completed without emitting a response."));
    private final ExchangeFunction exchangeFunction;
    private final UriBuilderFactory uriBuilderFactory;
    @Nullable
    private final HttpHeaders defaultHeaders;
    @Nullable
    private final MultiValueMap<String, String> defaultCookies;
    private final DefaultWebClientBuilder builder;

    DefaultWebClient(ExchangeFunction exchangeFunction, @Nullable UriBuilderFactory factory, @Nullable HttpHeaders defaultHeaders, @Nullable MultiValueMap<String, String> defaultCookies, DefaultWebClientBuilder builder) {
        this.exchangeFunction = exchangeFunction;
        this.uriBuilderFactory = factory != null ? factory : new DefaultUriBuilderFactory();
        this.defaultHeaders = defaultHeaders;
        this.defaultCookies = defaultCookies;
        this.builder = builder;
    }

    @Override
    public WebClient.RequestHeadersUriSpec<?> get() {
        return this.methodInternal(HttpMethod.GET);
    }

    @Override
    public WebClient.RequestHeadersUriSpec<?> head() {
        return this.methodInternal(HttpMethod.HEAD);
    }

    @Override
    public WebClient.RequestBodyUriSpec post() {
        return this.methodInternal(HttpMethod.POST);
    }

    @Override
    public WebClient.RequestBodyUriSpec put() {
        return this.methodInternal(HttpMethod.PUT);
    }

    @Override
    public WebClient.RequestBodyUriSpec patch() {
        return this.methodInternal(HttpMethod.PATCH);
    }

    @Override
    public WebClient.RequestHeadersUriSpec<?> delete() {
        return this.methodInternal(HttpMethod.DELETE);
    }

    @Override
    public WebClient.RequestHeadersUriSpec<?> options() {
        return this.methodInternal(HttpMethod.OPTIONS);
    }

    @Override
    public WebClient.RequestBodyUriSpec method(HttpMethod httpMethod) {
        return this.methodInternal(httpMethod);
    }

    private WebClient.RequestBodyUriSpec methodInternal(HttpMethod httpMethod) {
        return new DefaultRequestBodyUriSpec(httpMethod);
    }

    @Override
    public WebClient.Builder mutate() {
        return new DefaultWebClientBuilder(this.builder);
    }

    private static class DefaultResponseSpec
    implements WebClient.ResponseSpec {
        private static final StatusHandler DEFAULT_STATUS_HANDLER = new StatusHandler(HttpStatus::isError, DefaultResponseSpec::createResponseException);
        private final Mono<ClientResponse> responseMono;
        private List<StatusHandler> statusHandlers = new ArrayList<StatusHandler>(1);

        DefaultResponseSpec(Mono<ClientResponse> responseMono) {
            this.responseMono = responseMono;
            this.statusHandlers.add(DEFAULT_STATUS_HANDLER);
        }

        @Override
        public WebClient.ResponseSpec onStatus(Predicate<HttpStatus> statusPredicate, Function<ClientResponse, Mono<? extends Throwable>> exceptionFunction) {
            Assert.notNull(statusPredicate, (String)"'statusPredicate' must not be null");
            Assert.notNull(exceptionFunction, (String)"'exceptionFunction' must not be null");
            if (this.statusHandlers.size() == 1 && this.statusHandlers.get(0) == DEFAULT_STATUS_HANDLER) {
                this.statusHandlers.clear();
            }
            this.statusHandlers.add(new StatusHandler(statusPredicate, exceptionFunction));
            return this;
        }

        @Override
        public <T> Mono<T> bodyToMono(Class<T> bodyType) {
            return this.responseMono.flatMap(response -> this.bodyToPublisher((ClientResponse)response, BodyExtractors.toMono(bodyType), this::monoThrowableToMono));
        }

        @Override
        public <T> Mono<T> bodyToMono(ParameterizedTypeReference<T> typeReference) {
            return this.responseMono.flatMap(response -> this.bodyToPublisher((ClientResponse)response, BodyExtractors.toMono(typeReference), this::monoThrowableToMono));
        }

        private <T> Mono<T> monoThrowableToMono(Mono<? extends Throwable> mono) {
            return mono.flatMap(Mono::error);
        }

        @Override
        public <T> Flux<T> bodyToFlux(Class<T> elementType) {
            return this.responseMono.flatMapMany(response -> this.bodyToPublisher((ClientResponse)response, BodyExtractors.toFlux(elementType), this::monoThrowableToFlux));
        }

        @Override
        public <T> Flux<T> bodyToFlux(ParameterizedTypeReference<T> typeReference) {
            return this.responseMono.flatMapMany(response -> this.bodyToPublisher((ClientResponse)response, BodyExtractors.toFlux(typeReference), this::monoThrowableToFlux));
        }

        private <T> Flux<T> monoThrowableToFlux(Mono<? extends Throwable> mono) {
            return mono.flatMapMany(Flux::error);
        }

        private <T extends Publisher<?>> T bodyToPublisher(ClientResponse response, BodyExtractor<T, ? super ClientHttpResponse> extractor, Function<Mono<? extends Throwable>, T> errorFunction) {
            return (T)this.statusHandlers.stream().filter(statusHandler -> statusHandler.test(response.statusCode())).findFirst().map(statusHandler -> statusHandler.apply(response)).map(errorFunction::apply).orElse((Publisher)response.body(extractor));
        }

        private static Mono<WebClientResponseException> createResponseException(ClientResponse response) {
            return response.body(BodyExtractors.toDataBuffers()).reduce((rec$, xva$0) -> ((DataBuffer)rec$).write(new DataBuffer[]{xva$0})).map(dataBuffer -> {
                byte[] bytes = new byte[dataBuffer.readableByteCount()];
                dataBuffer.read(bytes);
                DataBufferUtils.release((DataBuffer)dataBuffer);
                return bytes;
            }).defaultIfEmpty((Object)new byte[0]).map(bodyBytes -> {
                String msg = String.format("ClientResponse has erroneous status code: %d %s", response.statusCode().value(), response.statusCode().getReasonPhrase());
                Charset charset = response.headers().contentType().map(MimeType::getCharset).orElse(StandardCharsets.ISO_8859_1);
                return new WebClientResponseException(msg, response.statusCode().value(), response.statusCode().getReasonPhrase(), response.headers().asHttpHeaders(), (byte[])bodyBytes, charset);
            });
        }

        private static class StatusHandler {
            private final Predicate<HttpStatus> predicate;
            private final Function<ClientResponse, Mono<? extends Throwable>> exceptionFunction;

            public StatusHandler(Predicate<HttpStatus> predicate, Function<ClientResponse, Mono<? extends Throwable>> exceptionFunction) {
                this.predicate = predicate;
                this.exceptionFunction = exceptionFunction;
            }

            public boolean test(HttpStatus status) {
                return this.predicate.test(status);
            }

            public Mono<? extends Throwable> apply(ClientResponse response) {
                return this.exceptionFunction.apply(response);
            }
        }
    }

    private class DefaultRequestBodyUriSpec
    implements WebClient.RequestBodyUriSpec {
        private final HttpMethod httpMethod;
        @Nullable
        private URI uri;
        @Nullable
        private HttpHeaders headers;
        @Nullable
        private MultiValueMap<String, String> cookies;
        @Nullable
        private BodyInserter<?, ? super ClientHttpRequest> inserter;
        @Nullable
        private Map<String, Object> attributes;

        DefaultRequestBodyUriSpec(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        public WebClient.RequestBodySpec uri(String uriTemplate, Object ... uriVariables) {
            return this.uri(DefaultWebClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public WebClient.RequestBodySpec uri(String uriTemplate, Map<String, ?> uriVariables) {
            return this.uri(DefaultWebClient.this.uriBuilderFactory.expand(uriTemplate, uriVariables));
        }

        @Override
        public WebClient.RequestBodySpec uri(Function<UriBuilder, URI> uriFunction) {
            return this.uri(uriFunction.apply(DefaultWebClient.this.uriBuilderFactory.builder()));
        }

        @Override
        public WebClient.RequestBodySpec uri(URI uri) {
            this.uri = uri;
            return this;
        }

        private HttpHeaders getHeaders() {
            if (this.headers == null) {
                this.headers = new HttpHeaders();
            }
            return this.headers;
        }

        private MultiValueMap<String, String> getCookies() {
            if (this.cookies == null) {
                this.cookies = new LinkedMultiValueMap(4);
            }
            return this.cookies;
        }

        private Map<String, Object> getAttributes() {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, Object>(4);
            }
            return this.attributes;
        }

        @Override
        public DefaultRequestBodyUriSpec header(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.getHeaders().add(headerName, headerValue);
            }
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec headers(Consumer<HttpHeaders> headersConsumer) {
            Assert.notNull(headersConsumer, (String)"'headersConsumer' must not be null");
            headersConsumer.accept(this.getHeaders());
            return this;
        }

        @Override
        public WebClient.RequestBodySpec attribute(String name, Object value) {
            this.getAttributes().put(name, value);
            return this;
        }

        @Override
        public WebClient.RequestBodySpec attributes(Consumer<Map<String, Object>> attributesConsumer) {
            Assert.notNull(attributesConsumer, (String)"'attributesConsumer' must not be null");
            attributesConsumer.accept(this.getAttributes());
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec accept(MediaType ... acceptableMediaTypes) {
            this.getHeaders().setAccept(Arrays.asList(acceptableMediaTypes));
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec acceptCharset(Charset ... acceptableCharsets) {
            this.getHeaders().setAcceptCharset(Arrays.asList(acceptableCharsets));
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec contentType(MediaType contentType2) {
            this.getHeaders().setContentType(contentType2);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec contentLength(long contentLength) {
            this.getHeaders().setContentLength(contentLength);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec cookie(String name, String value) {
            this.getCookies().add((Object)name, (Object)value);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec cookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
            Assert.notNull(cookiesConsumer, (String)"'cookiesConsumer' must not be null");
            cookiesConsumer.accept(this.getCookies());
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec ifModifiedSince(ZonedDateTime ifModifiedSince) {
            ZonedDateTime gmt = ifModifiedSince.withZoneSameInstant(ZoneId.of("GMT"));
            String headerValue = DateTimeFormatter.RFC_1123_DATE_TIME.format(gmt);
            this.getHeaders().set("If-Modified-Since", headerValue);
            return this;
        }

        @Override
        public DefaultRequestBodyUriSpec ifNoneMatch(String ... ifNoneMatches) {
            this.getHeaders().setIfNoneMatch(Arrays.asList(ifNoneMatches));
            return this;
        }

        @Override
        public WebClient.RequestHeadersSpec<?> body(BodyInserter<?, ? super ClientHttpRequest> inserter) {
            this.inserter = inserter;
            return this;
        }

        @Override
        public <T, P extends Publisher<T>> WebClient.RequestHeadersSpec<?> body(P publisher, ParameterizedTypeReference<T> typeReference) {
            this.inserter = BodyInserters.fromPublisher(publisher, typeReference);
            return this;
        }

        @Override
        public <T, P extends Publisher<T>> WebClient.RequestHeadersSpec<?> body(P publisher, Class<T> elementClass) {
            this.inserter = BodyInserters.fromPublisher(publisher, elementClass);
            return this;
        }

        @Override
        public WebClient.RequestHeadersSpec<?> syncBody(Object body2) {
            Assert.isTrue((!(body2 instanceof Publisher) ? 1 : 0) != 0, (String)"Please specify the element class by using body(Publisher, Class)");
            this.inserter = BodyInserters.fromObject(body2);
            return this;
        }

        @Override
        public Mono<ClientResponse> exchange() {
            ClientRequest request = this.inserter != null ? this.initRequestBuilder().body(this.inserter).build() : this.initRequestBuilder().build();
            return DefaultWebClient.this.exchangeFunction.exchange(request).switchIfEmpty(NO_HTTP_CLIENT_RESPONSE_ERROR);
        }

        private ClientRequest.Builder initRequestBuilder() {
            URI uri = this.uri != null ? this.uri : DefaultWebClient.this.uriBuilderFactory.expand("", new Object[0]);
            return ClientRequest.method(this.httpMethod, uri).headers((HttpHeaders headers2) -> headers2.addAll((MultiValueMap)this.initHeaders())).cookies((MultiValueMap<String, String> cookies) -> cookies.addAll(this.initCookies())).attributes((Map<String, Object> attributes) -> attributes.putAll(this.getAttributes()));
        }

        private HttpHeaders initHeaders() {
            if (CollectionUtils.isEmpty((Map)this.headers)) {
                return DefaultWebClient.this.defaultHeaders != null ? DefaultWebClient.this.defaultHeaders : new HttpHeaders();
            }
            if (CollectionUtils.isEmpty((Map)DefaultWebClient.this.defaultHeaders)) {
                return this.headers;
            }
            HttpHeaders result = new HttpHeaders();
            result.putAll((Map)this.headers);
            DefaultWebClient.this.defaultHeaders.forEach((name, values) -> {
                if (!this.headers.containsKey(name)) {
                    values.forEach(value -> result.add(name, value));
                }
            });
            return result;
        }

        private MultiValueMap<String, String> initCookies() {
            if (CollectionUtils.isEmpty(this.cookies)) {
                return DefaultWebClient.this.defaultCookies != null ? DefaultWebClient.this.defaultCookies : new LinkedMultiValueMap(0);
            }
            if (CollectionUtils.isEmpty((Map)DefaultWebClient.this.defaultCookies)) {
                return this.cookies;
            }
            LinkedMultiValueMap result = new LinkedMultiValueMap();
            result.putAll(this.cookies);
            DefaultWebClient.this.defaultCookies.forEach((arg_0, arg_1) -> ((MultiValueMap)result).putIfAbsent(arg_0, arg_1));
            return result;
        }

        @Override
        public WebClient.ResponseSpec retrieve() {
            return new DefaultResponseSpec(this.exchange());
        }
    }
}

