/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.HandlerAdapter;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.result.method.InvocableHandlerMethod;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.reactive.result.method.annotation.ControllerMethodResolver;
import org.springframework.web.reactive.result.method.annotation.InitBinderBindingContext;
import org.springframework.web.reactive.result.method.annotation.ModelInitializer;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RequestMappingHandlerAdapter
implements HandlerAdapter,
ApplicationContextAware,
InitializingBean {
    private static final Log logger = LogFactory.getLog(RequestMappingHandlerAdapter.class);
    private List<HttpMessageReader<?>> messageReaders = Collections.emptyList();
    @Nullable
    private WebBindingInitializer webBindingInitializer;
    @Nullable
    private ArgumentResolverConfigurer argumentResolverConfigurer;
    @Nullable
    private ReactiveAdapterRegistry reactiveAdapterRegistry;
    @Nullable
    private ConfigurableApplicationContext applicationContext;
    @Nullable
    private ControllerMethodResolver methodResolver;
    @Nullable
    private ModelInitializer modelInitializer;

    public void setMessageReaders(List<HttpMessageReader<?>> messageReaders) {
        Assert.notNull(messageReaders, (String)"'messageReaders' must not be null");
        this.messageReaders = messageReaders;
    }

    public List<HttpMessageReader<?>> getMessageReaders() {
        return this.messageReaders;
    }

    public void setWebBindingInitializer(@Nullable WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    @Nullable
    public WebBindingInitializer getWebBindingInitializer() {
        return this.webBindingInitializer;
    }

    public void setArgumentResolverConfigurer(@Nullable ArgumentResolverConfigurer configurer) {
        this.argumentResolverConfigurer = configurer;
    }

    @Nullable
    public ArgumentResolverConfigurer getArgumentResolverConfigurer() {
        return this.argumentResolverConfigurer;
    }

    public void setReactiveAdapterRegistry(@Nullable ReactiveAdapterRegistry registry) {
        this.reactiveAdapterRegistry = registry;
    }

    @Nullable
    public ReactiveAdapterRegistry getReactiveAdapterRegistry() {
        return this.reactiveAdapterRegistry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.applicationContext, (String)"ApplicationContext is required");
        if (CollectionUtils.isEmpty(this.messageReaders)) {
            ServerCodecConfigurer codecConfigurer = ServerCodecConfigurer.create();
            this.messageReaders = codecConfigurer.getReaders();
        }
        if (this.argumentResolverConfigurer == null) {
            this.argumentResolverConfigurer = new ArgumentResolverConfigurer();
        }
        if (this.reactiveAdapterRegistry == null) {
            this.reactiveAdapterRegistry = new ReactiveAdapterRegistry();
        }
        this.methodResolver = new ControllerMethodResolver(this.argumentResolverConfigurer, this.messageReaders, this.reactiveAdapterRegistry, this.applicationContext);
        this.modelInitializer = new ModelInitializer(this.methodResolver, this.reactiveAdapterRegistry);
    }

    @Override
    public boolean supports(Object handler) {
        return HandlerMethod.class.equals(handler.getClass());
    }

    @Override
    public Mono<HandlerResult> handle(ServerWebExchange exchange, Object handler) {
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Assert.state((this.methodResolver != null && this.modelInitializer != null ? 1 : 0) != 0, (String)"Not initialized");
        InitBinderBindingContext bindingContext = new InitBinderBindingContext(this.getWebBindingInitializer(), this.methodResolver.getInitBinderMethods(handlerMethod));
        InvocableHandlerMethod invocableMethod = this.methodResolver.getRequestMappingMethod(handlerMethod);
        Function<Throwable, Mono> exceptionHandler = ex -> this.handleException((Throwable)ex, handlerMethod, bindingContext, exchange);
        return this.modelInitializer.initModel(handlerMethod, bindingContext, exchange).then(Mono.defer(() -> invocableMethod.invoke(exchange, bindingContext, new Object[0]))).doOnNext(result -> result.setExceptionHandler(exceptionHandler)).doOnNext(result -> bindingContext.saveModel()).onErrorResume(exceptionHandler);
    }

    private Mono<HandlerResult> handleException(Throwable exception, HandlerMethod handlerMethod, BindingContext bindingContext, ServerWebExchange exchange) {
        block5: {
            Assert.state((this.methodResolver != null ? 1 : 0) != 0, (String)"Not initialized");
            InvocableHandlerMethod invocable = this.methodResolver.getExceptionHandlerMethod(exception, handlerMethod);
            if (invocable != null) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Invoking @ExceptionHandler method: " + invocable.getMethod()));
                    }
                    bindingContext.getModel().asMap().clear();
                    Throwable cause = exception.getCause();
                    if (cause != null) {
                        return invocable.invoke(exchange, bindingContext, exception, cause, handlerMethod);
                    }
                    return invocable.invoke(exchange, bindingContext, exception, handlerMethod);
                }
                catch (Throwable invocationEx) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn((Object)("Failed to invoke: " + invocable.getMethod()), invocationEx);
                }
            }
        }
        return Mono.error((Throwable)exception);
    }
}

