/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.Conventions;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.server.DefaultServerResponseBuilder;
import org.springframework.web.reactive.function.server.RenderingResponse;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultRenderingResponseBuilder
implements RenderingResponse.Builder {
    private final String name;
    private HttpStatus status = HttpStatus.OK;
    private final HttpHeaders headers = new HttpHeaders();
    private final Map<String, Object> model = new LinkedHashMap<String, Object>();

    public DefaultRenderingResponseBuilder(String name) {
        this.name = name;
    }

    @Override
    public RenderingResponse.Builder status(HttpStatus status) {
        Assert.notNull((Object)status, (String)"'status' must not be null");
        this.status = status;
        return this;
    }

    @Override
    public RenderingResponse.Builder modelAttribute(Object attribute) {
        Assert.notNull((Object)attribute, (String)"'value' must not be null");
        if (attribute instanceof Collection && ((Collection)attribute).isEmpty()) {
            return this;
        }
        return this.modelAttribute(Conventions.getVariableName((Object)attribute), attribute);
    }

    @Override
    public RenderingResponse.Builder modelAttribute(String name, @Nullable Object value) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        this.model.put(name, value);
        return this;
    }

    @Override
    public RenderingResponse.Builder modelAttributes(Object ... attributes) {
        this.modelAttributes(Arrays.asList(attributes));
        return this;
    }

    @Override
    public RenderingResponse.Builder modelAttributes(Collection<?> attributes) {
        attributes.forEach(this::modelAttribute);
        return this;
    }

    @Override
    public RenderingResponse.Builder modelAttributes(Map<String, ?> attributes) {
        this.model.putAll(attributes);
        return this;
    }

    @Override
    public RenderingResponse.Builder header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public RenderingResponse.Builder headers(HttpHeaders headers2) {
        this.headers.putAll((Map)headers2);
        return this;
    }

    @Override
    public Mono<RenderingResponse> build() {
        return Mono.just((Object)new DefaultRenderingResponse(this.status, this.headers, this.name, this.model));
    }

    private static final class DefaultRenderingResponse
    extends DefaultServerResponseBuilder.AbstractServerResponse
    implements RenderingResponse {
        private final String name;
        private final Map<String, Object> model;

        public DefaultRenderingResponse(HttpStatus statusCode, HttpHeaders headers2, String name, Map<String, Object> model) {
            super(statusCode, headers2);
            this.name = name;
            this.model = DefaultRenderingResponse.unmodifiableCopy(model);
        }

        private static <K, V> Map<K, V> unmodifiableCopy(Map<? extends K, ? extends V> m) {
            return Collections.unmodifiableMap(new LinkedHashMap<K, V>(m));
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Map<String, Object> model() {
            return this.model;
        }

        @Override
        public Mono<Void> writeTo(ServerWebExchange exchange, ServerResponse.Context context) {
            ServerHttpResponse response = exchange.getResponse();
            this.writeStatusAndHeaders(response);
            MediaType contentType2 = exchange.getResponse().getHeaders().getContentType();
            Locale locale = LocaleContextHolder.getLocale((LocaleContext)exchange.getLocaleContext());
            Stream viewResolverStream = context.viewResolvers().stream();
            return Flux.fromStream(viewResolverStream).concatMap(viewResolver -> viewResolver.resolveViewName(this.name(), locale)).next().switchIfEmpty(Mono.error((Throwable)new IllegalArgumentException("Could not resolve view with name '" + this.name() + "'"))).flatMap(view -> view.render(this.model(), contentType2, exchange));
        }
    }
}

