/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.server.ServerWebExchange;

public class FixedContentTypeResolver
implements RequestedContentTypeResolver {
    private static final Log logger = LogFactory.getLog(FixedContentTypeResolver.class);
    private final List<MediaType> mediaTypes;

    public FixedContentTypeResolver(MediaType mediaType) {
        this(Collections.singletonList(mediaType));
    }

    public FixedContentTypeResolver(List<MediaType> mediaTypes) {
        this.mediaTypes = Collections.unmodifiableList(mediaTypes);
    }

    public List<MediaType> getContentTypes() {
        return this.mediaTypes;
    }

    @Override
    public List<MediaType> resolveMediaTypes(ServerWebExchange exchange) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requested media types: " + this.mediaTypes));
        }
        return this.mediaTypes;
    }
}

