/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

class TomcatHeadersAdapter
implements MultiValueMap<String, String> {
    private final MimeHeaders headers;

    TomcatHeadersAdapter(MimeHeaders headers) {
        this.headers = headers;
    }

    public String getFirst(String key) {
        return this.headers.getHeader(key);
    }

    public void add(String key, @Nullable String value) {
        this.headers.addValue(key).setString(value);
    }

    public void addAll(String key, List<? extends String> values) {
        values.forEach(value -> this.add(key, (String)value));
    }

    public void addAll(MultiValueMap<String, String> values) {
        values.forEach(this::addAll);
    }

    public void set(String key, @Nullable String value) {
        this.headers.setValue(key).setString(value);
    }

    public void setAll(Map<String, String> values) {
        values.forEach(this::set);
    }

    public Map<String, String> toSingleValueMap() {
        LinkedHashMap singleValueMap = CollectionUtils.newLinkedHashMap((int)this.headers.size());
        this.keySet().forEach(key -> singleValueMap.put(key, this.getFirst((String)key)));
        return singleValueMap;
    }

    public int size() {
        Enumeration names = this.headers.names();
        LinkedHashSet<String> deduplicated = new LinkedHashSet<String>();
        while (names.hasMoreElements()) {
            deduplicated.add(((String)names.nextElement()).toLowerCase(Locale.ROOT));
        }
        return deduplicated.size();
    }

    public boolean isEmpty() {
        return this.headers.size() == 0;
    }

    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String headerName = (String)key;
            return this.headers.findHeader(headerName, 0) != -1;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (value instanceof String) {
            String text = (String)value;
            MessageBytes messageBytes = MessageBytes.newInstance();
            messageBytes.setString(text);
            for (int i = 0; i < this.headers.size(); ++i) {
                if (!this.headers.getValue(i).equals(messageBytes)) continue;
                return true;
            }
        }
        return false;
    }

    public @Nullable List<String> get(Object key) {
        if (this.containsKey(key)) {
            return Collections.list(this.headers.values((String)key));
        }
        return null;
    }

    public @Nullable List<String> put(String key, List<String> value) {
        Object previousValues = this.get(key);
        this.headers.removeHeader(key);
        value.forEach(v -> this.headers.addValue(key).setString(v));
        return previousValues;
    }

    public @Nullable List<String> remove(Object key) {
        if (key instanceof String) {
            String headerName = (String)key;
            Object previousValues = this.get(key);
            this.headers.removeHeader(headerName);
            return previousValues;
        }
        return null;
    }

    public void putAll(Map<? extends String, ? extends List<String>> map) {
        map.forEach(this::put);
    }

    public void clear() {
        this.headers.recycle();
    }

    public Set<String> keySet() {
        return new HeaderNames();
    }

    public Collection<List<String>> values() {
        return this.keySet().stream().map(object -> this.get(object)).toList();
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return TomcatHeadersAdapter.this.size();
            }
        };
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    private class HeaderNames
    extends AbstractSet<String> {
        private HeaderNames() {
        }

        @Override
        public Iterator<String> iterator() {
            return new HeaderNamesIterator(TomcatHeadersAdapter.this.headers.names());
        }

        @Override
        public int size() {
            Enumeration names = TomcatHeadersAdapter.this.headers.names();
            int size = 0;
            while (names.hasMoreElements()) {
                names.nextElement();
                ++size;
            }
            return size;
        }
    }

    private final class HeaderNamesIterator
    implements Iterator<String> {
        private final Enumeration<String> enumeration;
        private @Nullable String currentName;

        private HeaderNamesIterator(Enumeration<String> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public String next() {
            this.currentName = this.enumeration.nextElement();
            return this.currentName;
        }

        @Override
        public void remove() {
            if (this.currentName == null) {
                throw new IllegalStateException("No current Header in iterator");
            }
            boolean found = false;
            for (int i = 0; i < TomcatHeadersAdapter.this.headers.size(); ++i) {
                if (!TomcatHeadersAdapter.this.headers.getName(i).equalsIgnoreCase(this.currentName)) continue;
                TomcatHeadersAdapter.this.headers.removeHeader(i--);
                found = true;
            }
            if (!found) {
                throw new IllegalStateException("Header not present: " + this.currentName);
            }
        }
    }

    private final class HeaderEntry
    implements Map.Entry<String, List<String>> {
        private final String key;

        HeaderEntry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public @Nullable List<String> getValue() {
            return TomcatHeadersAdapter.this.get(this.key);
        }

        @Override
        public @Nullable List<String> setValue(List<String> value) {
            Object previous = this.getValue();
            TomcatHeadersAdapter.this.headers.removeHeader(this.key);
            TomcatHeadersAdapter.this.addAll(this.key, value);
            return previous;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private final Enumeration<String> names;

        private EntryIterator() {
            this.names = TomcatHeadersAdapter.this.headers.names();
        }

        @Override
        public boolean hasNext() {
            return this.names.hasMoreElements();
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return new HeaderEntry(this.names.nextElement());
        }
    }
}

