/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverters;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.ResourceRegionHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.cbor.JacksonCborHttpMessageConverter;
import org.springframework.http.converter.cbor.KotlinSerializationCborHttpMessageConverter;
import org.springframework.http.converter.cbor.MappingJackson2CborHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import org.springframework.http.converter.json.JsonbHttpMessageConverter;
import org.springframework.http.converter.json.KotlinSerializationJsonHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.protobuf.KotlinSerializationProtobufHttpMessageConverter;
import org.springframework.http.converter.smile.JacksonSmileHttpMessageConverter;
import org.springframework.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.JacksonXmlHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.http.converter.yaml.JacksonYamlHttpMessageConverter;
import org.springframework.http.converter.yaml.MappingJackson2YamlHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class DefaultHttpMessageConverters
implements HttpMessageConverters {
    private final List<HttpMessageConverter<?>> messageConverters;

    DefaultHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }

    @Override
    public Iterator<HttpMessageConverter<?>> iterator() {
        return this.messageConverters.iterator();
    }

    static class DefaultServerBuilder
    extends DefaultBuilder
    implements HttpMessageConverters.ServerBuilder {
        DefaultServerBuilder() {
        }

        @Override
        public HttpMessageConverters.ServerBuilder registerDefaults() {
            this.registerDefaults = true;
            return this;
        }

        @Override
        public HttpMessageConverters.ServerBuilder stringMessageConverter(HttpMessageConverter<?> stringMessageConverter) {
            this.setStringMessageConverter(stringMessageConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ServerBuilder jsonMessageConverter(HttpMessageConverter<?> jsonMessageConverter) {
            this.setJsonMessageConverter(jsonMessageConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ServerBuilder xmlMessageConverter(HttpMessageConverter<?> xmlMessageConverter) {
            this.setXmlMessageConverter(xmlMessageConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ServerBuilder smileMessageConverter(HttpMessageConverter<?> smileMessageConverter) {
            this.setSmileMessageConverter(smileMessageConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ServerBuilder cborMessageConverter(HttpMessageConverter<?> cborMessageConverter) {
            this.setCborMessageConverter(cborMessageConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ServerBuilder yamlMessageConverter(HttpMessageConverter<?> yamlMessageConverter) {
            this.setYamlMessageConverter(yamlMessageConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ServerBuilder customMessageConverter(HttpMessageConverter<?> customConverter) {
            this.addCustomMessageConverter(customConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ServerBuilder configureMessageConverters(Consumer<HttpMessageConverter<?>> configurer) {
            this.addMessageConverterConfigurer(configurer);
            return this;
        }

        @Override
        public HttpMessageConverters build() {
            if (this.registerDefaults) {
                this.resourceMessageConverter = new ResourceHttpMessageConverter();
                this.resourceRegionMessageConverter = new ResourceRegionHttpMessageConverter();
                this.detectMessageConverters();
            }
            ArrayList allConverters = new ArrayList();
            ArrayList partConverters = new ArrayList();
            partConverters.addAll(this.getCustomConverters());
            partConverters.addAll(this.getCoreConverters());
            allConverters.addAll(this.getCustomConverters());
            allConverters.addAll(this.getBaseConverters());
            if (this.resourceMessageConverter != null) {
                allConverters.add(this.resourceMessageConverter);
            }
            if (this.resourceRegionMessageConverter != null) {
                allConverters.add(this.resourceRegionMessageConverter);
            }
            if (!partConverters.isEmpty() || !allConverters.isEmpty()) {
                allConverters.add(new AllEncompassingFormHttpMessageConverter(partConverters));
            }
            allConverters.addAll(this.getCoreConverters());
            if (this.configurer != null) {
                allConverters.forEach(this.configurer);
            }
            return new DefaultHttpMessageConverters(allConverters);
        }
    }

    static class DefaultClientBuilder
    extends DefaultBuilder
    implements HttpMessageConverters.ClientBuilder {
        DefaultClientBuilder() {
        }

        @Override
        public DefaultClientBuilder registerDefaults() {
            this.registerDefaults = true;
            return this;
        }

        @Override
        public HttpMessageConverters.ClientBuilder stringMessageConverter(HttpMessageConverter<?> stringMessageConverter) {
            this.setStringMessageConverter(stringMessageConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ClientBuilder jsonMessageConverter(HttpMessageConverter<?> jsonMessageConverter) {
            this.setJsonMessageConverter(jsonMessageConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ClientBuilder xmlMessageConverter(HttpMessageConverter<?> xmlMessageConverter) {
            this.setXmlMessageConverter(xmlMessageConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ClientBuilder smileMessageConverter(HttpMessageConverter<?> smileMessageConverter) {
            this.setSmileMessageConverter(smileMessageConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ClientBuilder cborMessageConverter(HttpMessageConverter<?> cborMessageConverter) {
            this.setCborMessageConverter(cborMessageConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ClientBuilder yamlMessageConverter(HttpMessageConverter<?> yamlMessageConverter) {
            this.setYamlMessageConverter(yamlMessageConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ClientBuilder customMessageConverter(HttpMessageConverter<?> customConverter) {
            this.addCustomMessageConverter(customConverter);
            return this;
        }

        @Override
        public HttpMessageConverters.ClientBuilder configureMessageConverters(Consumer<HttpMessageConverter<?>> configurer) {
            this.addMessageConverterConfigurer(configurer);
            return this;
        }

        @Override
        public HttpMessageConverters build() {
            if (this.registerDefaults) {
                this.resourceMessageConverter = new ResourceHttpMessageConverter(false);
                this.detectMessageConverters();
            }
            ArrayList allConverters = new ArrayList();
            ArrayList partConverters = new ArrayList();
            partConverters.addAll(this.getCustomConverters());
            partConverters.addAll(this.getCoreConverters());
            allConverters.addAll(this.getCustomConverters());
            allConverters.addAll(this.getBaseConverters());
            if (this.resourceMessageConverter != null) {
                allConverters.add(this.resourceMessageConverter);
            }
            if (!partConverters.isEmpty() || !allConverters.isEmpty()) {
                allConverters.add(new AllEncompassingFormHttpMessageConverter(partConverters));
            }
            allConverters.addAll(this.getCoreConverters());
            if (this.configurer != null) {
                allConverters.forEach(this.configurer);
            }
            return new DefaultHttpMessageConverters(allConverters);
        }
    }

    static abstract class DefaultBuilder {
        private static final boolean isJacksonPresent;
        private static final boolean isJackson2Present;
        private static final boolean isGsonPresent;
        private static final boolean isJsonbPresent;
        private static final boolean isKotlinSerializationJsonPresent;
        private static final boolean isJacksonXmlPresent;
        private static final boolean isJackson2XmlPresent;
        private static final boolean isJaxb2Present;
        private static final boolean isJacksonSmilePresent;
        private static final boolean isJackson2SmilePresent;
        private static final boolean isJacksonCborPresent;
        private static final boolean isJackson2CborPresent;
        private static final boolean isKotlinSerializationCborPresent;
        private static final boolean isJacksonYamlPresent;
        private static final boolean isJackson2YamlPresent;
        private static final boolean isKotlinSerializationProtobufPresent;
        private static final boolean isRomePresent;
        boolean registerDefaults;
        @Nullable ByteArrayHttpMessageConverter byteArrayMessageConverter;
        @Nullable HttpMessageConverter<?> stringMessageConverter;
        @Nullable HttpMessageConverter<?> resourceMessageConverter;
        @Nullable HttpMessageConverter<?> resourceRegionMessageConverter;
        @Nullable Consumer<HttpMessageConverter<?>> configurer;
        @Nullable HttpMessageConverter<?> jsonMessageConverter;
        @Nullable HttpMessageConverter<?> xmlMessageConverter;
        @Nullable HttpMessageConverter<?> smileMessageConverter;
        @Nullable HttpMessageConverter<?> cborMessageConverter;
        @Nullable HttpMessageConverter<?> yamlMessageConverter;
        @Nullable HttpMessageConverter<?> protobufMessageConverter;
        @Nullable HttpMessageConverter<?> atomMessageConverter;
        @Nullable HttpMessageConverter<?> rssMessageConverter;
        final List<HttpMessageConverter<?>> customMessageConverters = new ArrayList();

        DefaultBuilder() {
        }

        void setStringMessageConverter(HttpMessageConverter<?> stringMessageConverter) {
            Assert.isTrue((boolean)stringMessageConverter.getSupportedMediaTypes().contains(MediaType.TEXT_PLAIN), (String)"stringMessageConverter should support 'text/plain'");
            this.stringMessageConverter = stringMessageConverter;
        }

        void setJsonMessageConverter(HttpMessageConverter<?> jsonMessageConverter) {
            Assert.isTrue((boolean)jsonMessageConverter.getSupportedMediaTypes().contains(MediaType.APPLICATION_JSON), (String)"jsonMessageConverter should support 'application/json'");
            this.jsonMessageConverter = jsonMessageConverter;
        }

        void setXmlMessageConverter(HttpMessageConverter<?> xmlMessageConverter) {
            Assert.isTrue((boolean)xmlMessageConverter.getSupportedMediaTypes().contains(MediaType.TEXT_XML), (String)"xmlMessageConverter should support 'text/xml'");
            this.xmlMessageConverter = xmlMessageConverter;
        }

        void setSmileMessageConverter(HttpMessageConverter<?> smileMessageConverter) {
            Assert.isTrue((boolean)smileMessageConverter.getSupportedMediaTypes().contains(new MediaType("application", "x-jackson-smile")), (String)"smileMessageConverter should support 'application/x-jackson-smile'");
            this.smileMessageConverter = smileMessageConverter;
        }

        void setCborMessageConverter(HttpMessageConverter<?> cborMessageConverter) {
            Assert.isTrue((boolean)cborMessageConverter.getSupportedMediaTypes().contains(MediaType.APPLICATION_CBOR), (String)"cborMessageConverter should support 'application/cbor'");
            this.cborMessageConverter = cborMessageConverter;
        }

        void setYamlMessageConverter(HttpMessageConverter<?> yamlMessageConverter) {
            Assert.isTrue((boolean)yamlMessageConverter.getSupportedMediaTypes().contains(MediaType.APPLICATION_YAML), (String)"yamlMessageConverter should support 'application/yaml'");
            this.yamlMessageConverter = yamlMessageConverter;
        }

        void addCustomMessageConverter(HttpMessageConverter<?> customConverter) {
            Assert.notNull(customConverter, (String)"'customConverter' must not be null");
            this.customMessageConverters.add(customConverter);
        }

        void addMessageConverterConfigurer(Consumer<HttpMessageConverter<?>> configurer) {
            this.configurer = this.configurer != null ? configurer.andThen(this.configurer) : configurer;
        }

        List<HttpMessageConverter<?>> getBaseConverters() {
            ArrayList converters = new ArrayList();
            if (this.byteArrayMessageConverter != null) {
                converters.add(this.byteArrayMessageConverter);
            }
            if (this.stringMessageConverter != null) {
                converters.add(this.stringMessageConverter);
            }
            return converters;
        }

        List<HttpMessageConverter<?>> getCoreConverters() {
            ArrayList converters = new ArrayList();
            if (this.jsonMessageConverter != null) {
                converters.add(this.jsonMessageConverter);
            }
            if (this.smileMessageConverter != null) {
                converters.add(this.smileMessageConverter);
            }
            if (this.cborMessageConverter != null) {
                converters.add(this.cborMessageConverter);
            }
            if (this.yamlMessageConverter != null) {
                converters.add(this.yamlMessageConverter);
            }
            if (this.xmlMessageConverter != null) {
                converters.add(this.xmlMessageConverter);
            }
            if (this.protobufMessageConverter != null) {
                converters.add(this.protobufMessageConverter);
            }
            if (this.atomMessageConverter != null) {
                converters.add(this.atomMessageConverter);
            }
            if (this.rssMessageConverter != null) {
                converters.add(this.rssMessageConverter);
            }
            return converters;
        }

        List<HttpMessageConverter<?>> getCustomConverters() {
            return this.customMessageConverters;
        }

        void detectMessageConverters() {
            this.byteArrayMessageConverter = new ByteArrayHttpMessageConverter();
            this.stringMessageConverter = new StringHttpMessageConverter();
            if (this.jsonMessageConverter == null) {
                if (isJacksonPresent) {
                    this.jsonMessageConverter = new JacksonJsonHttpMessageConverter();
                } else if (isJackson2Present) {
                    this.jsonMessageConverter = new MappingJackson2HttpMessageConverter();
                } else if (isGsonPresent) {
                    this.jsonMessageConverter = new GsonHttpMessageConverter();
                } else if (isJsonbPresent) {
                    this.jsonMessageConverter = new JsonbHttpMessageConverter();
                } else if (isKotlinSerializationJsonPresent) {
                    this.jsonMessageConverter = new KotlinSerializationJsonHttpMessageConverter();
                }
            }
            if (this.xmlMessageConverter == null) {
                if (isJacksonXmlPresent) {
                    this.xmlMessageConverter = new JacksonXmlHttpMessageConverter();
                } else if (isJackson2XmlPresent) {
                    this.xmlMessageConverter = new MappingJackson2XmlHttpMessageConverter();
                } else if (isJaxb2Present) {
                    this.xmlMessageConverter = new Jaxb2RootElementHttpMessageConverter();
                }
            }
            if (this.smileMessageConverter == null) {
                if (isJacksonSmilePresent) {
                    this.smileMessageConverter = new JacksonSmileHttpMessageConverter();
                } else if (isJackson2SmilePresent) {
                    this.smileMessageConverter = new MappingJackson2SmileHttpMessageConverter();
                }
            }
            if (this.cborMessageConverter == null) {
                if (isJacksonCborPresent) {
                    this.cborMessageConverter = new JacksonCborHttpMessageConverter();
                } else if (isJackson2CborPresent) {
                    this.cborMessageConverter = new MappingJackson2CborHttpMessageConverter();
                } else if (isKotlinSerializationCborPresent) {
                    this.cborMessageConverter = new KotlinSerializationCborHttpMessageConverter();
                }
            }
            if (this.yamlMessageConverter == null) {
                if (isJacksonYamlPresent) {
                    this.yamlMessageConverter = new JacksonYamlHttpMessageConverter();
                } else if (isJackson2YamlPresent) {
                    this.yamlMessageConverter = new MappingJackson2YamlHttpMessageConverter();
                }
            }
            if (this.protobufMessageConverter == null && isKotlinSerializationProtobufPresent) {
                this.protobufMessageConverter = new KotlinSerializationProtobufHttpMessageConverter();
            }
            if (isRomePresent) {
                if (this.atomMessageConverter == null) {
                    this.atomMessageConverter = new AtomFeedHttpMessageConverter();
                }
                if (this.rssMessageConverter == null) {
                    this.rssMessageConverter = new RssChannelHttpMessageConverter();
                }
            }
        }

        static {
            ClassLoader classLoader = DefaultBuilder.class.getClassLoader();
            isJacksonPresent = ClassUtils.isPresent((String)"tools.jackson.databind.ObjectMapper", (ClassLoader)classLoader);
            isJackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)classLoader);
            isGsonPresent = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)classLoader);
            isJsonbPresent = ClassUtils.isPresent((String)"jakarta.json.bind.Jsonb", (ClassLoader)classLoader);
            isKotlinSerializationJsonPresent = ClassUtils.isPresent((String)"kotlinx.serialization.json.Json", (ClassLoader)classLoader);
            isJacksonSmilePresent = isJacksonPresent && ClassUtils.isPresent((String)"tools.jackson.dataformat.smile.SmileMapper", (ClassLoader)classLoader);
            isJackson2SmilePresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.smile.SmileFactory", (ClassLoader)classLoader);
            isJaxb2Present = ClassUtils.isPresent((String)"jakarta.xml.bind.Binder", (ClassLoader)classLoader);
            isJacksonXmlPresent = isJacksonPresent && ClassUtils.isPresent((String)"tools.jackson.dataformat.xml.XmlMapper", (ClassLoader)classLoader);
            isJackson2XmlPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.xml.XmlMapper", (ClassLoader)classLoader);
            isJacksonCborPresent = isJacksonPresent && ClassUtils.isPresent((String)"tools.jackson.dataformat.cbor.CBORMapper", (ClassLoader)classLoader);
            isJackson2CborPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.cbor.CBORFactory", (ClassLoader)classLoader);
            isJacksonYamlPresent = isJacksonPresent && ClassUtils.isPresent((String)"tools.jackson.dataformat.yaml.YAMLMapper", (ClassLoader)classLoader);
            isJackson2YamlPresent = ClassUtils.isPresent((String)"com.fasterxml.jackson.dataformat.yaml.YAMLFactory", (ClassLoader)classLoader);
            isKotlinSerializationCborPresent = ClassUtils.isPresent((String)"kotlinx.serialization.cbor.Cbor", (ClassLoader)classLoader);
            isKotlinSerializationProtobufPresent = ClassUtils.isPresent((String)"kotlinx.serialization.protobuf.ProtoBuf", (ClassLoader)classLoader);
            isRomePresent = ClassUtils.isPresent((String)"com.rometools.rome.feed.WireFeed", (ClassLoader)classLoader);
        }
    }
}

