/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.json;

import org.assertj.core.api.AssertProvider;
import org.jspecify.annotations.Nullable;
import org.springframework.test.http.HttpMessageContentConverter;
import org.springframework.test.json.JsonContentAssert;
import org.springframework.test.json.JsonConverterDelegate;
import org.springframework.util.Assert;

public final class JsonContent
implements AssertProvider<JsonContentAssert> {
    private final String json;
    private final @Nullable JsonConverterDelegate converterDelegate;

    public JsonContent(String json, @Nullable JsonConverterDelegate converterDelegate) {
        Assert.notNull((Object)json, (String)"JSON must not be null");
        this.json = json;
        this.converterDelegate = converterDelegate;
    }

    @Deprecated(since="7.0", forRemoval=true)
    public JsonContent(String json, @Nullable HttpMessageContentConverter converter) {
        this(json, (JsonConverterDelegate)converter);
    }

    public JsonContent(String json) {
        this(json, (JsonConverterDelegate)null);
    }

    public JsonContentAssert assertThat() {
        return new JsonContentAssert(this);
    }

    public String getJson() {
        return this.json;
    }

    public @Nullable JsonConverterDelegate getJsonConverterDelegate() {
        return this.converterDelegate;
    }

    @Deprecated(since="7.0", forRemoval=true)
    @Nullable HttpMessageContentConverter getContentConverter() {
        HttpMessageContentConverter cc;
        JsonConverterDelegate jsonConverterDelegate = this.converterDelegate;
        return jsonConverterDelegate instanceof HttpMessageContentConverter ? (cc = (HttpMessageContentConverter)jsonConverterDelegate) : null;
    }

    public String toString() {
        return "JsonContent " + this.json;
    }
}

