/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.client.assertj;

import jakarta.servlet.http.Cookie;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ByteArrayAssert;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseCookie;
import org.springframework.test.http.HttpHeadersAssert;
import org.springframework.test.http.MediaTypeAssert;
import org.springframework.test.json.AbstractJsonContentAssert;
import org.springframework.test.json.JsonContent;
import org.springframework.test.json.JsonContentAssert;
import org.springframework.test.web.servlet.assertj.CookieMapAssert;
import org.springframework.test.web.servlet.client.ExchangeResult;
import org.springframework.test.web.servlet.client.assertj.RestTestClientResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.util.function.SingletonSupplier;

public class RestTestClientResponseAssert
extends AbstractObjectAssert<RestTestClientResponseAssert, RestTestClientResponse> {
    private final Supplier<MediaTypeAssert> contentTypeAssertSupplier = SingletonSupplier.of(() -> new MediaTypeAssert(this.getExchangeResult().getResponseHeaders().getContentType()));
    private final Supplier<HttpHeadersAssert> headersAssertSupplier = SingletonSupplier.of(() -> new HttpHeadersAssert(this.getExchangeResult().getResponseHeaders()));
    private final Supplier<AbstractIntegerAssert<?>> statusAssert = SingletonSupplier.of(() -> (AbstractIntegerAssert)Assertions.assertThat((int)this.getExchangeResult().getStatus().value()).as("HTTP status code", new Object[0]));

    RestTestClientResponseAssert(RestTestClientResponse actual) {
        super((Object)actual, RestTestClientResponseAssert.class);
    }

    public RestTestClientResponseAssert hasStatus(int status) {
        this.status().isEqualTo(status);
        return (RestTestClientResponseAssert)this.myself;
    }

    public RestTestClientResponseAssert hasStatus(HttpStatus status) {
        return this.hasStatus(status.value());
    }

    public RestTestClientResponseAssert hasStatusOk() {
        return this.hasStatus(HttpStatus.OK);
    }

    public RestTestClientResponseAssert hasStatus1xxInformational() {
        return this.hasStatusSeries(HttpStatus.Series.INFORMATIONAL);
    }

    public RestTestClientResponseAssert hasStatus2xxSuccessful() {
        return this.hasStatusSeries(HttpStatus.Series.SUCCESSFUL);
    }

    public RestTestClientResponseAssert hasStatus3xxRedirection() {
        return this.hasStatusSeries(HttpStatus.Series.REDIRECTION);
    }

    public RestTestClientResponseAssert hasStatus4xxClientError() {
        return this.hasStatusSeries(HttpStatus.Series.CLIENT_ERROR);
    }

    public RestTestClientResponseAssert hasStatus5xxServerError() {
        return this.hasStatusSeries(HttpStatus.Series.SERVER_ERROR);
    }

    private RestTestClientResponseAssert hasStatusSeries(HttpStatus.Series series) {
        HttpStatusCode status = this.getExchangeResult().getStatus();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)HttpStatus.Series.resolve((int)status.value())).as("HTTP status series", new Object[0])).isEqualTo((Object)series);
        return (RestTestClientResponseAssert)this.myself;
    }

    private AbstractIntegerAssert<?> status() {
        return this.statusAssert.get();
    }

    public HttpHeadersAssert headers() {
        return this.headersAssertSupplier.get();
    }

    public RestTestClientResponseAssert containsHeader(String name) {
        this.headers().containsHeader(name);
        return (RestTestClientResponseAssert)this.myself;
    }

    public RestTestClientResponseAssert doesNotContainHeader(String name) {
        this.headers().doesNotContainHeader(name);
        return (RestTestClientResponseAssert)this.myself;
    }

    public RestTestClientResponseAssert hasHeader(String name, String value) {
        this.headers().hasValue(name, value);
        return (RestTestClientResponseAssert)this.myself;
    }

    public MediaTypeAssert contentType() {
        return this.contentTypeAssertSupplier.get();
    }

    public RestTestClientResponseAssert hasContentType(MediaType contentType) {
        this.contentType().isEqualTo(contentType);
        return (RestTestClientResponseAssert)this.myself;
    }

    public RestTestClientResponseAssert hasContentType(String contentType) {
        this.contentType().isEqualTo(contentType);
        return (RestTestClientResponseAssert)this.myself;
    }

    public RestTestClientResponseAssert hasContentTypeCompatibleWith(MediaType contentType) {
        this.contentType().isCompatibleWith(contentType);
        return (RestTestClientResponseAssert)this.myself;
    }

    public RestTestClientResponseAssert hasContentTypeCompatibleWith(String contentType) {
        this.contentType().isCompatibleWith(contentType);
        return (RestTestClientResponseAssert)this.myself;
    }

    public CookieMapAssert cookies() {
        return new CookieMapAssert(this.getCookies());
    }

    private Cookie[] getCookies() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        MultiValueMap<String, ResponseCookie> responseCookies = this.getExchangeResult().getResponseCookies();
        for (String name : responseCookies.keySet()) {
            for (ResponseCookie responseCookie : (List)responseCookies.get((Object)name)) {
                Cookie cookie = new Cookie(name, responseCookie.getValue());
                if (!responseCookie.getMaxAge().isNegative()) {
                    cookie.setMaxAge((int)responseCookie.getMaxAge().getSeconds());
                }
                if (responseCookie.getDomain() != null) {
                    cookie.setDomain(responseCookie.getDomain());
                }
                if (responseCookie.getPath() != null) {
                    cookie.setPath(responseCookie.getPath());
                }
                if (responseCookie.getSameSite() != null) {
                    cookie.setAttribute("SameSite", responseCookie.getSameSite());
                }
                cookie.setSecure(responseCookie.isSecure());
                cookie.setHttpOnly(responseCookie.isHttpOnly());
                if (responseCookie.isPartitioned()) {
                    cookie.setAttribute("Partitioned", "");
                }
                cookies.add(cookie);
            }
        }
        return cookies.toArray(new Cookie[0]);
    }

    public AbstractByteArrayAssert<?> body() {
        return new ByteArrayAssert(this.getExchangeResult().getResponseBodyContent());
    }

    public AbstractStringAssert<?> bodyText() {
        return Assertions.assertThat((String)this.readBody());
    }

    public RestTestClientResponseAssert hasBodyTextEqualTo(String bodyText) {
        this.bodyText().isEqualTo(bodyText);
        return (RestTestClientResponseAssert)this.myself;
    }

    public AbstractJsonContentAssert<?> bodyJson() {
        return new JsonContentAssert(new JsonContent(this.readBody(), this.getExchangeResult().getMessageContentConverter()));
    }

    private String readBody() {
        return new String(this.getExchangeResult().getResponseBodyContent(), this.getCharset());
    }

    private Charset getCharset() {
        ExchangeResult result = this.getExchangeResult();
        MediaType contentType = result.getResponseHeaders().getContentType();
        Charset charset = contentType != null ? contentType.getCharset() : null;
        return charset != null ? charset : StandardCharsets.UTF_8;
    }

    private ExchangeResult getExchangeResult() {
        return ((RestTestClientResponse)this.actual).getExchangeResult();
    }
}

