/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.client;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.test.json.JsonAssert;
import org.springframework.test.json.JsonComparator;
import org.springframework.test.json.JsonCompareMode;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.ExceptionCollector;
import org.springframework.test.util.XmlExpectationsHelper;
import org.springframework.test.web.servlet.client.CookieAssertions;
import org.springframework.test.web.servlet.client.DefaultRestTestClientBuilder;
import org.springframework.test.web.servlet.client.EntityExchangeResult;
import org.springframework.test.web.servlet.client.ExchangeResult;
import org.springframework.test.web.servlet.client.HeaderAssertions;
import org.springframework.test.web.servlet.client.JsonPathAssertions;
import org.springframework.test.web.servlet.client.RestTestClient;
import org.springframework.test.web.servlet.client.StatusAssertions;
import org.springframework.test.web.servlet.client.XpathAssertions;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriBuilder;

class DefaultRestTestClient
implements RestTestClient {
    private final RestClient restClient;
    private final Consumer<EntityExchangeResult<?>> entityResultConsumer;
    private final DefaultRestTestClientBuilder<?> restTestClientBuilder;
    private final AtomicLong requestIndex = new AtomicLong();

    DefaultRestTestClient(RestClient.Builder builder, Consumer<EntityExchangeResult<?>> entityResultConsumer, DefaultRestTestClientBuilder<?> restTestClientBuilder) {
        this.restClient = builder.build();
        this.entityResultConsumer = entityResultConsumer;
        this.restTestClientBuilder = restTestClientBuilder;
    }

    @Override
    public RestTestClient.RequestHeadersUriSpec<?> get() {
        return this.methodInternal(HttpMethod.GET);
    }

    @Override
    public RestTestClient.RequestHeadersUriSpec<?> head() {
        return this.methodInternal(HttpMethod.HEAD);
    }

    @Override
    public RestTestClient.RequestBodyUriSpec post() {
        return this.methodInternal(HttpMethod.POST);
    }

    @Override
    public RestTestClient.RequestBodyUriSpec put() {
        return this.methodInternal(HttpMethod.PUT);
    }

    @Override
    public RestTestClient.RequestBodyUriSpec patch() {
        return this.methodInternal(HttpMethod.PATCH);
    }

    @Override
    public RestTestClient.RequestHeadersUriSpec<?> delete() {
        return this.methodInternal(HttpMethod.DELETE);
    }

    @Override
    public RestTestClient.RequestHeadersUriSpec<?> options() {
        return this.methodInternal(HttpMethod.OPTIONS);
    }

    @Override
    public RestTestClient.RequestBodyUriSpec method(HttpMethod httpMethod) {
        return this.methodInternal(httpMethod);
    }

    private RestTestClient.RequestBodyUriSpec methodInternal(HttpMethod httpMethod) {
        return new DefaultRequestBodyUriSpec(this.restClient.method(httpMethod));
    }

    @Override
    public <B extends RestTestClient.Builder<B>> RestTestClient.Builder<B> mutate() {
        return this.restTestClientBuilder;
    }

    private class DefaultRequestBodyUriSpec
    implements RestTestClient.RequestBodyUriSpec {
        private final RestClient.RequestBodyUriSpec requestHeadersUriSpec;
        private @Nullable String uriTemplate;

        DefaultRequestBodyUriSpec(RestClient.RequestBodyUriSpec spec) {
            this.requestHeadersUriSpec = spec;
            String requestId = String.valueOf(DefaultRestTestClient.this.requestIndex.incrementAndGet());
            this.requestHeadersUriSpec.header("RestTestClient-Request-Id", new String[]{requestId});
        }

        @Override
        public RestTestClient.RequestBodySpec uri(String uriTemplate, Object ... uriVariables) {
            this.uriTemplate = uriTemplate;
            this.requestHeadersUriSpec.uri(uriTemplate, uriVariables);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec uri(String uri, Map<String, ?> uriVariables) {
            this.uriTemplate = uri;
            this.requestHeadersUriSpec.uri(uri, uriVariables);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec uri(Function<UriBuilder, URI> uriFunction) {
            this.uriTemplate = null;
            this.requestHeadersUriSpec.uri(uriFunction);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec uri(URI uri) {
            this.uriTemplate = null;
            this.requestHeadersUriSpec.uri(uri);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec header(String headerName, String ... headerValues) {
            this.requestHeadersUriSpec.header(headerName, headerValues);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec headers(Consumer<HttpHeaders> headersConsumer) {
            this.requestHeadersUriSpec.headers(headersConsumer);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec accept(MediaType ... acceptableMediaTypes) {
            this.requestHeadersUriSpec.accept(acceptableMediaTypes);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec acceptCharset(Charset ... acceptableCharsets) {
            this.requestHeadersUriSpec.acceptCharset(acceptableCharsets);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec contentType(MediaType contentType) {
            this.requestHeadersUriSpec.contentType(contentType);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec contentLength(long contentLength) {
            this.requestHeadersUriSpec.contentLength(contentLength);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec cookie(String name, String value) {
            this.requestHeadersUriSpec.cookie(name, value);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec cookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
            this.requestHeadersUriSpec.cookies(cookiesConsumer);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec ifModifiedSince(ZonedDateTime ifModifiedSince) {
            this.requestHeadersUriSpec.ifModifiedSince(ifModifiedSince);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec ifNoneMatch(String ... ifNoneMatches) {
            this.requestHeadersUriSpec.ifNoneMatch(ifNoneMatches);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec attribute(String name, Object value) {
            this.requestHeadersUriSpec.attribute(name, value);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec attributes(Consumer<Map<String, Object>> attributesConsumer) {
            this.requestHeadersUriSpec.attributes(attributesConsumer);
            return this;
        }

        @Override
        public RestTestClient.RequestBodySpec apiVersion(Object version) {
            this.requestHeadersUriSpec.apiVersion(version);
            return this;
        }

        @Override
        public RestTestClient.RequestHeadersSpec<?> body(Object body2) {
            this.requestHeadersUriSpec.body(body2);
            return this;
        }

        @Override
        public RestTestClient.ResponseSpec exchange() {
            return new DefaultResponseSpec((ExchangeResult)this.requestHeadersUriSpec.exchangeForRequiredValue((request, response) -> new ExchangeResult(request, response, this.uriTemplate), false), DefaultRestTestClient.this.entityResultConsumer);
        }
    }

    private static class DefaultBodyContentSpec
    implements RestTestClient.BodyContentSpec {
        private final EntityExchangeResult<byte[]> result;

        DefaultBodyContentSpec(EntityExchangeResult<byte[]> result) {
            this.result = result;
        }

        @Override
        public EntityExchangeResult<Void> isEmpty() {
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertTrue("Expected empty body", this.result.getBody(byte[].class) == null));
            return new EntityExchangeResult<Object>(this.result, null);
        }

        @Override
        public RestTestClient.BodyContentSpec json(String expectedJson, JsonCompareMode compareMode) {
            return this.json(expectedJson, JsonAssert.comparator(compareMode));
        }

        @Override
        public RestTestClient.BodyContentSpec json(String expectedJson, JsonComparator comparator) {
            this.result.assertWithDiagnostics(() -> {
                try {
                    comparator.assertIsMatch(expectedJson, this.getBodyAsString());
                }
                catch (Exception ex) {
                    throw new AssertionError("JSON parsing error", ex);
                }
            });
            return this;
        }

        @Override
        public RestTestClient.BodyContentSpec xml(String expectedXml) {
            this.result.assertWithDiagnostics(() -> {
                try {
                    new XmlExpectationsHelper().assertXmlEqual(expectedXml, this.getBodyAsString());
                }
                catch (Exception ex) {
                    throw new AssertionError("XML parsing error", ex);
                }
            });
            return this;
        }

        @Override
        public JsonPathAssertions jsonPath(String expression) {
            return new JsonPathAssertions(this, this.getBodyAsString(), expression, null);
        }

        @Override
        public XpathAssertions xpath(String expression, @Nullable Map<String, String> namespaces, Object ... args) {
            return new XpathAssertions(this, expression, namespaces, args);
        }

        private String getBodyAsString() {
            byte[] body2 = this.result.getResponseBody();
            if (body2 == null || body2.length == 0) {
                return "";
            }
            Charset charset = Optional.ofNullable(this.result.getResponseHeaders().getContentType()).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
            return new String(body2, charset);
        }

        @Override
        public RestTestClient.BodyContentSpec consumeWith(Consumer<EntityExchangeResult<byte[]>> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.result));
            return this;
        }

        @Override
        public EntityExchangeResult<byte[]> returnResult() {
            return this.result;
        }
    }

    private static class DefaultBodySpec<B, S extends RestTestClient.BodySpec<B, S>>
    implements RestTestClient.BodySpec<B, S> {
        private final EntityExchangeResult<B> result;

        DefaultBodySpec(EntityExchangeResult<B> result) {
            this.result = result;
        }

        @Override
        public <T extends S> T isEqualTo(@Nullable B expected) {
            this.result.assertWithDiagnostics(() -> AssertionErrors.assertEquals("Response body", expected, this.result.getResponseBody()));
            return this.self();
        }

        @Override
        public <T extends S> T value(Matcher<? super @Nullable B> matcher) {
            this.result.assertWithDiagnostics(() -> MatcherAssert.assertThat(this.result.getResponseBody(), (Matcher)matcher));
            return this.self();
        }

        @Override
        public <T extends S, R> T value(Function<@Nullable B, @Nullable R> bodyMapper, Matcher<? super @Nullable R> matcher) {
            this.result.assertWithDiagnostics(() -> {
                B body2 = this.result.getResponseBody();
                MatcherAssert.assertThat(bodyMapper.apply(body2), (Matcher)matcher);
            });
            return this.self();
        }

        @Override
        public <T extends S> T value(Consumer<@Nullable B> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.result.getResponseBody()));
            return this.self();
        }

        @Override
        public <T extends S> T consumeWith(Consumer<EntityExchangeResult<B>> consumer) {
            this.result.assertWithDiagnostics(() -> consumer.accept(this.result));
            return this.self();
        }

        private <T extends S> T self() {
            return (T)this;
        }

        @Override
        public EntityExchangeResult<B> returnResult() {
            return this.result;
        }
    }

    private static class DefaultResponseSpec
    implements RestTestClient.ResponseSpec {
        private final ExchangeResult exchangeResult;
        private final Consumer<EntityExchangeResult<?>> entityResultConsumer;

        DefaultResponseSpec(ExchangeResult result, Consumer<EntityExchangeResult<?>> entityResultConsumer) {
            this.exchangeResult = result;
            this.entityResultConsumer = entityResultConsumer;
        }

        @Override
        public StatusAssertions expectStatus() {
            return new StatusAssertions(this.exchangeResult, this);
        }

        @Override
        public HeaderAssertions expectHeader() {
            return new HeaderAssertions(this.exchangeResult, this);
        }

        @Override
        public CookieAssertions expectCookie() {
            return new CookieAssertions(this.exchangeResult, this);
        }

        @Override
        public <B> RestTestClient.BodySpec<B, ?> expectBody(Class<B> bodyType) {
            B body2 = this.exchangeResult.getBody(bodyType);
            EntityExchangeResult<B> result = new EntityExchangeResult<B>(this.exchangeResult, body2);
            return new DefaultBodySpec(result);
        }

        @Override
        public <B> RestTestClient.BodySpec<B, ?> expectBody(ParameterizedTypeReference<B> bodyType) {
            B body2 = this.exchangeResult.getBody(bodyType);
            EntityExchangeResult<B> result = this.initExchangeResult(body2);
            return new DefaultBodySpec(result);
        }

        @Override
        public RestTestClient.BodyContentSpec expectBody() {
            byte[] body2 = this.exchangeResult.getBody(byte[].class);
            EntityExchangeResult<byte[]> result = this.initExchangeResult(body2);
            return new DefaultBodyContentSpec(result);
        }

        @Override
        public <T> EntityExchangeResult<T> returnResult(Class<T> elementClass) {
            return this.initExchangeResult(this.exchangeResult.getBody(elementClass));
        }

        @Override
        public <T> EntityExchangeResult<T> returnResult(ParameterizedTypeReference<T> elementTypeRef) {
            return this.initExchangeResult(this.exchangeResult.getBody(elementTypeRef));
        }

        private <B> EntityExchangeResult<B> initExchangeResult(@Nullable B body2) {
            EntityExchangeResult result = new EntityExchangeResult(this.exchangeResult, body2);
            result.assertWithDiagnostics(() -> this.entityResultConsumer.accept(result));
            return result;
        }

        @Override
        public RestTestClient.ResponseSpec expectAll(RestTestClient.ResponseSpec.ResponseSpecConsumer ... consumers) {
            ExceptionCollector exceptionCollector = new ExceptionCollector();
            for (RestTestClient.ResponseSpec.ResponseSpecConsumer consumer : consumers) {
                exceptionCollector.execute(() -> consumer.accept(this));
            }
            try {
                exceptionCollector.assertEmpty();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new AssertionError(ex.getMessage(), ex);
            }
            return this;
        }
    }
}

