/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.MediaType;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.util.MimeType;

record JsonEncoderDecoder(Encoder<?> encoder, Decoder<?> decoder) {
    private static final ResolvableType MAP_TYPE = ResolvableType.forClass(Map.class);

    static @Nullable JsonEncoderDecoder from(Collection<HttpMessageWriter<?>> messageWriters, Collection<HttpMessageReader<?>> messageReaders) {
        Encoder<?> jsonEncoder = JsonEncoderDecoder.findJsonEncoder(messageWriters);
        Decoder<?> jsonDecoder = JsonEncoderDecoder.findJsonDecoder(messageReaders);
        if (jsonEncoder != null && jsonDecoder != null) {
            return new JsonEncoderDecoder(jsonEncoder, jsonDecoder);
        }
        return null;
    }

    private static @Nullable Encoder<?> findJsonEncoder(Collection<HttpMessageWriter<?>> writers) {
        return JsonEncoderDecoder.findJsonEncoder(writers.stream().filter(EncoderHttpMessageWriter.class::isInstance).map(writer -> ((EncoderHttpMessageWriter)writer).getEncoder()));
    }

    private static @Nullable Encoder<?> findJsonEncoder(Stream<Encoder<?>> stream) {
        return stream.filter(encoder -> encoder.canEncode(MAP_TYPE, (MimeType)MediaType.APPLICATION_JSON)).findFirst().orElse(null);
    }

    private static @Nullable Decoder<?> findJsonDecoder(Collection<HttpMessageReader<?>> readers) {
        return JsonEncoderDecoder.findJsonDecoder(readers.stream().filter(DecoderHttpMessageReader.class::isInstance).map(reader -> ((DecoderHttpMessageReader)reader).getDecoder()));
    }

    private static @Nullable Decoder<?> findJsonDecoder(Stream<Decoder<?>> decoderStream) {
        return decoderStream.filter(decoder -> decoder.canDecode(MAP_TYPE, (MimeType)MediaType.APPLICATION_JSON)).findFirst().orElse(null);
    }
}

