/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.internal.Failures;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.util.UriComponentsBuilder;

public class UriAssert
extends AbstractStringAssert<UriAssert> {
    private static final AntPathMatcher pathMatcher = new AntPathMatcher();
    private final String displayName;

    public UriAssert(@Nullable String actual, String displayName) {
        super(actual, UriAssert.class);
        this.displayName = displayName;
        this.as(displayName, new Object[0]);
    }

    public UriAssert isEqualToTemplate(String uriTemplate, Object ... uriVars) {
        String uri = this.buildUri(uriTemplate, uriVars);
        return (UriAssert)this.isEqualTo(uri);
    }

    public UriAssert matchesAntPattern(String uriPattern) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)pathMatcher.isPattern(uriPattern)).withFailMessage("'%s' is not an Ant-style path pattern", new Object[]{uriPattern})).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)pathMatcher.match(uriPattern, (String)this.actual)).withFailMessage("%s '%s' does not match the expected URI pattern '%s'", new Object[]{this.displayName, this.actual, uriPattern})).isTrue();
        return this;
    }

    private String buildUri(String uriTemplate, Object ... uriVars) {
        try {
            return UriComponentsBuilder.fromUriString((String)uriTemplate).buildAndExpand(uriVars).encode().toUriString();
        }
        catch (Exception ex) {
            throw Failures.instance().failure((AssertionInfo)this.info, (ErrorMessageFactory)new ShouldBeValidUriTemplate(uriTemplate, ex.getMessage()));
        }
    }

    private static final class ShouldBeValidUriTemplate
    extends BasicErrorMessageFactory {
        private ShouldBeValidUriTemplate(String uriTemplate, String errorMessage) {
            super("%nExpecting:%n  %s%nTo be a valid URI template but got:%n  %s%n", new Object[]{uriTemplate, errorMessage});
        }
    }
}

