/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client.match;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.test.util.AssertionErrors;
import org.springframework.test.util.JsonExpectationsHelper;
import org.springframework.test.util.XmlExpectationsHelper;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.util.MultiValueMap;
import org.w3c.dom.Node;

public class ContentRequestMatchers {
    private final XmlExpectationsHelper xmlHelper = new XmlExpectationsHelper();
    private final JsonExpectationsHelper jsonHelper = new JsonExpectationsHelper();

    protected ContentRequestMatchers() {
    }

    public RequestMatcher contentType(String expectedContentType) {
        return this.contentType(MediaType.parseMediaType((String)expectedContentType));
    }

    public RequestMatcher contentType(MediaType expectedContentType) {
        return request2 -> {
            MediaType actualContentType = request2.getHeaders().getContentType();
            AssertionErrors.assertTrue("Content type not set", actualContentType != null);
            AssertionErrors.assertEquals("Content type", expectedContentType, actualContentType);
        };
    }

    public RequestMatcher contentTypeCompatibleWith(String contentType) {
        return this.contentTypeCompatibleWith(MediaType.parseMediaType((String)contentType));
    }

    public RequestMatcher contentTypeCompatibleWith(MediaType contentType) {
        return request2 -> {
            MediaType actualContentType = request2.getHeaders().getContentType();
            AssertionErrors.assertTrue("Content type not set", actualContentType != null);
            if (actualContentType != null) {
                AssertionErrors.assertTrue("Content type [" + actualContentType + "] is not compatible with [" + contentType + "]", actualContentType.isCompatibleWith(contentType));
            }
        };
    }

    public RequestMatcher string(Matcher<? super String> matcher) {
        return request2 -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
            MatcherAssert.assertThat((String)"Request content", (Object)mockRequest.getBodyAsString(), (Matcher)matcher);
        };
    }

    public RequestMatcher string(String expectedContent) {
        return request2 -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
            AssertionErrors.assertEquals("Request content", expectedContent, mockRequest.getBodyAsString());
        };
    }

    public RequestMatcher bytes(byte[] expectedContent) {
        return request2 -> {
            MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
            AssertionErrors.assertEquals("Request content", expectedContent, mockRequest.getBodyAsBytes());
        };
    }

    public RequestMatcher formData(MultiValueMap<String, String> expectedContent) {
        return request2 -> {
            HttpInputMessage inputMessage = new HttpInputMessage(){

                public InputStream getBody() throws IOException {
                    MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
                    return new ByteArrayInputStream(mockRequest.getBodyAsBytes());
                }

                public HttpHeaders getHeaders() {
                    return request2.getHeaders();
                }
            };
            FormHttpMessageConverter converter = new FormHttpMessageConverter();
            AssertionErrors.assertEquals("Request content", expectedContent, converter.read(null, inputMessage));
        };
    }

    public RequestMatcher xml(final String expectedXmlContent) {
        return new AbstractXmlRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws Exception {
                ContentRequestMatchers.this.xmlHelper.assertXmlEqual(expectedXmlContent, request2.getBodyAsString());
            }
        };
    }

    public RequestMatcher node(final Matcher<? super Node> matcher) {
        return new AbstractXmlRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws Exception {
                ContentRequestMatchers.this.xmlHelper.assertNode(request2.getBodyAsString(), (Matcher<? super Node>)matcher);
            }
        };
    }

    public RequestMatcher source(final Matcher<? super Source> matcher) {
        return new AbstractXmlRequestMatcher(){

            @Override
            protected void matchInternal(MockClientHttpRequest request2) throws Exception {
                ContentRequestMatchers.this.xmlHelper.assertSource(request2.getBodyAsString(), (Matcher<? super Source>)matcher);
            }
        };
    }

    public RequestMatcher json(String expectedJsonContent) {
        return this.json(expectedJsonContent, false);
    }

    public RequestMatcher json(String expectedJsonContent, boolean strict) {
        return request2 -> {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
                this.jsonHelper.assertJsonEqual(expectedJsonContent, mockRequest.getBodyAsString(), strict);
            }
            catch (Exception ex) {
                throw new AssertionError("Failed to parse expected or actual JSON request content", ex);
            }
        };
    }

    private static abstract class AbstractXmlRequestMatcher
    implements RequestMatcher {
        private AbstractXmlRequestMatcher() {
        }

        @Override
        public final void match(ClientHttpRequest request2) throws IOException, AssertionError {
            try {
                MockClientHttpRequest mockRequest = (MockClientHttpRequest)request2;
                this.matchInternal(mockRequest);
            }
            catch (Exception ex) {
                throw new AssertionError("Failed to parse expected or actual XML request content", ex);
            }
        }

        protected abstract void matchInternal(MockClientHttpRequest var1) throws Exception;
    }
}

