/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import org.quartz.SchedulerConfigException;
import org.quartz.simpl.SimpleThreadPool;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.util.Assert;

public class SimpleThreadPoolTaskExecutor
extends SimpleThreadPool
implements SchedulingTaskExecutor,
InitializingBean,
DisposableBean {
    private boolean waitForJobsToCompleteOnShutdown = false;

    public void setWaitForJobsToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.waitForJobsToCompleteOnShutdown = waitForJobsToCompleteOnShutdown;
    }

    public void afterPropertiesSet() throws SchedulerConfigException {
        this.initialize();
    }

    public void execute(Runnable task) {
        Assert.notNull((Object)task, (String)"Runnable must not be null");
        this.runInThread(task);
    }

    public boolean prefersShortLivedTasks() {
        return true;
    }

    public void destroy() {
        this.shutdown(this.waitForJobsToCompleteOnShutdown);
    }
}

