/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.struts;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ModuleConfig;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.DelegatingActionUtils;

public class AutowiringRequestProcessor
extends RequestProcessor {
    private WebApplicationContext webApplicationContext;
    private int autowireMode = 0;
    private boolean dependencyCheck = false;
    static /* synthetic */ Class class$org$apache$struts$action$ActionServlet;

    public void init(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        super.init(actionServlet, moduleConfig);
        if (actionServlet != null) {
            this.webApplicationContext = this.initWebApplicationContext(actionServlet, moduleConfig);
            this.autowireMode = this.initAutowireMode(actionServlet, moduleConfig);
            this.dependencyCheck = this.initDependencyCheck(actionServlet, moduleConfig);
        }
    }

    protected WebApplicationContext initWebApplicationContext(ActionServlet actionServlet, ModuleConfig moduleConfig) throws IllegalStateException {
        WebApplicationContext wac = DelegatingActionUtils.findRequiredWebApplicationContext(actionServlet, moduleConfig);
        if (wac instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)wac).getBeanFactory().ignoreDependencyType(class$org$apache$struts$action$ActionServlet == null ? (class$org$apache$struts$action$ActionServlet = AutowiringRequestProcessor.class$("org.apache.struts.action.ActionServlet")) : class$org$apache$struts$action$ActionServlet);
        }
        return wac;
    }

    protected int initAutowireMode(ActionServlet actionServlet, ModuleConfig moduleConfig) {
        return DelegatingActionUtils.getAutowireMode(actionServlet);
    }

    protected boolean initDependencyCheck(ActionServlet actionServlet, ModuleConfig moduleConfig) {
        return DelegatingActionUtils.getDependencyCheck(actionServlet);
    }

    protected final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected final int getAutowireMode() {
        return this.autowireMode;
    }

    protected final boolean getDependencyCheck() {
        return this.dependencyCheck;
    }

    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException {
        Action action = super.processActionCreate(request, response, mapping);
        this.getWebApplicationContext().getAutowireCapableBeanFactory().autowireBeanProperties((Object)action, this.getAutowireMode(), this.getDependencyCheck());
        return action;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

