/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.connection.lookup;

import io.r2dbc.spi.ConnectionFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.r2dbc.connection.lookup.ConnectionFactoryLookup;
import org.springframework.r2dbc.connection.lookup.ConnectionFactoryLookupFailureException;
import org.springframework.util.Assert;

public class BeanFactoryConnectionFactoryLookup
implements ConnectionFactoryLookup,
BeanFactoryAware {
    private @Nullable BeanFactory beanFactory;

    public BeanFactoryConnectionFactoryLookup() {
    }

    public BeanFactoryConnectionFactoryLookup(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public ConnectionFactory getConnectionFactory(String connectionFactoryName) throws ConnectionFactoryLookupFailureException {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory is required");
        try {
            return (ConnectionFactory)this.beanFactory.getBean(connectionFactoryName, ConnectionFactory.class);
        }
        catch (BeansException ex) {
            throw new ConnectionFactoryLookupFailureException(String.format("Failed to look up ConnectionFactory bean with name '%s'", connectionFactoryName), ex);
        }
    }
}

