/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.core;

import io.r2dbc.spi.OutParameters;
import io.r2dbc.spi.Readable;
import io.r2dbc.spi.ReadableMetadata;
import io.r2dbc.spi.Row;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.TypeConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeanPropertyRowMapper<T>
implements Function<Readable, T> {
    private final Class<T> mappedClass;
    private final ConversionService conversionService;
    private final Map<String, PropertyDescriptor> mappedProperties;

    public BeanPropertyRowMapper(Class<T> mappedClass) {
        this(mappedClass, DefaultConversionService.getSharedInstance());
    }

    public BeanPropertyRowMapper(Class<T> mappedClass, ConversionService conversionService) {
        Assert.notNull(mappedClass, (String)"Mapped Class must not be null");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        this.mappedClass = mappedClass;
        this.conversionService = conversionService;
        this.mappedProperties = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor pd : BeanUtils.getPropertyDescriptors(mappedClass)) {
            if (pd.getWriteMethod() == null) continue;
            String lowerCaseName = this.lowerCaseName(pd.getName());
            this.mappedProperties.put(lowerCaseName, pd);
            String underscoreName = this.underscoreName(pd.getName());
            if (lowerCaseName.equals(underscoreName)) continue;
            this.mappedProperties.put(underscoreName, pd);
        }
    }

    protected void suppressProperty(String propertyName) {
        this.mappedProperties.remove(this.lowerCaseName(propertyName));
        this.mappedProperties.remove(this.underscoreName(propertyName));
    }

    protected String lowerCaseName(String name) {
        return name.toLowerCase(Locale.US);
    }

    protected String underscoreName(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(Character.toLowerCase(name.charAt(0)));
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append('_').append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    @Override
    public T apply(Readable readable) {
        if (readable instanceof Row) {
            Row row = (Row)readable;
            return this.mapForReadable(row, row.getMetadata().getColumnMetadatas());
        }
        if (readable instanceof OutParameters) {
            OutParameters out = (OutParameters)readable;
            return this.mapForReadable(out, out.getMetadata().getParameterMetadatas());
        }
        throw new IllegalArgumentException("Can only map Readable Row or OutParameters, got " + readable.getClass().getName());
    }

    private <R extends Readable> T mapForReadable(R readable, List<? extends ReadableMetadata> readableMetadatas) {
        BeanWrapperImpl bw = new BeanWrapperImpl();
        bw.setConversionService(this.conversionService);
        T mappedObject = this.constructMappedInstance(readable, readableMetadatas, (TypeConverter)bw);
        bw.setBeanInstance(mappedObject);
        int readableItemCount = readableMetadatas.size();
        for (int itemIndex = 0; itemIndex < readableItemCount; ++itemIndex) {
            ReadableMetadata itemMetadata = readableMetadatas.get(itemIndex);
            String itemName = itemMetadata.getName();
            String property = this.lowerCaseName(StringUtils.delete((String)itemName, (String)" "));
            PropertyDescriptor pd = this.mappedProperties.get(property);
            if (pd == null) continue;
            Object value = this.getItemValue(readable, itemIndex, pd.getPropertyType());
            bw.setPropertyValue(pd.getName(), value);
        }
        return mappedObject;
    }

    protected T constructMappedInstance(Readable readable, List<? extends ReadableMetadata> itemMetadatas, TypeConverter tc) {
        return (T)BeanUtils.instantiateClass(this.mappedClass);
    }

    @Nullable
    protected Object getItemValue(Readable readable, int itemIndex, Class<?> paramType) {
        try {
            return readable.get(itemIndex, paramType);
        }
        catch (Throwable ex) {
            return readable.get(itemIndex);
        }
    }
}

