/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.connection;

import io.r2dbc.spi.Connection;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;

public class ConnectionHolder
extends ResourceHolderSupport {
    @Nullable
    private Connection currentConnection;
    private boolean transactionActive;

    public ConnectionHolder(Connection connection) {
        this(connection, false);
    }

    public ConnectionHolder(Connection connection, boolean transactionActive) {
        this.currentConnection = connection;
        this.transactionActive = transactionActive;
    }

    protected boolean hasConnection() {
        return this.currentConnection != null;
    }

    protected void setTransactionActive(boolean transactionActive) {
        this.transactionActive = transactionActive;
    }

    protected boolean isTransactionActive() {
        return this.transactionActive;
    }

    protected void setConnection(@Nullable Connection connection) {
        this.currentConnection = connection;
    }

    public Connection getConnection() {
        Assert.state((this.currentConnection != null ? 1 : 0) != 0, (String)"Active Connection is required");
        return this.currentConnection;
    }

    public void released() {
        super.released();
        if (!this.isOpen() && this.currentConnection != null) {
            this.currentConnection = null;
        }
    }

    public void clear() {
        super.clear();
        this.transactionActive = false;
    }
}

