/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.core;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public final class Parameter {
    @Nullable
    private final Object value;
    private final Class<?> type;

    private Parameter(@Nullable Object value, Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null");
        this.value = value;
        this.type = type;
    }

    public static Parameter from(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        return new Parameter(value, ClassUtils.getUserClass((Object)value));
    }

    public static Parameter fromOrEmpty(@Nullable Object value, Class<?> type) {
        return value == null ? Parameter.empty(type) : new Parameter(value, ClassUtils.getUserClass((Object)value));
    }

    public static Parameter empty(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null");
        return new Parameter(null, type);
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Parameter)) {
            return false;
        }
        Parameter that = (Parameter)other;
        return ObjectUtils.nullSafeEquals((Object)this.value, (Object)that.value) && ObjectUtils.nullSafeEquals(this.type, that.type);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.value) + ObjectUtils.nullSafeHashCode(this.type);
    }

    public String toString() {
        return "Parameter[value=" + this.value + ",type=" + this.type.getName() + "]";
    }
}

