/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.hibernate;

import jakarta.persistence.PersistenceException;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.PessimisticLockException;
import org.hibernate.PropertyValueException;
import org.hibernate.QueryException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransactionException;
import org.hibernate.TransientObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.dialect.lock.OptimisticEntityLockException;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionSubclassTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.JpaSystemException;

public class HibernateExceptionTranslator
implements PersistenceExceptionTranslator {
    private @Nullable SQLExceptionTranslator jdbcExceptionTranslator;
    private @Nullable SQLExceptionTranslator transactionExceptionTranslator = new SQLExceptionSubclassTranslator();

    public void setJdbcExceptionTranslator(@Nullable SQLExceptionTranslator exceptionTranslator) {
        this.jdbcExceptionTranslator = exceptionTranslator;
        this.transactionExceptionTranslator = exceptionTranslator;
    }

    public @Nullable DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        Throwable throwable;
        if (ex instanceof HibernateException) {
            HibernateException hibernateEx = (HibernateException)((Object)ex);
            return this.convertHibernateAccessException(hibernateEx);
        }
        if (ex instanceof PersistenceException && (throwable = ex.getCause()) instanceof HibernateException) {
            HibernateException hibernateEx = (HibernateException)throwable;
            return this.convertHibernateAccessException(hibernateEx);
        }
        return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        JDBCException jdbcEx;
        DataAccessException dae;
        if (this.jdbcExceptionTranslator != null && ex instanceof JDBCException && (dae = this.jdbcExceptionTranslator.translate("Hibernate operation: " + (jdbcEx = (JDBCException)ex).getMessage(), jdbcEx.getSQL(), jdbcEx.getSQLException())) != null) {
            return dae;
        }
        return this.convertHibernateAccessException(ex, ex);
    }

    private DataAccessException convertHibernateAccessException(HibernateException ex, HibernateException exToCheck) {
        SQLGrammarException hibEx;
        JDBCException jdbcEx;
        Throwable dae;
        if (this.jdbcExceptionTranslator != null && exToCheck instanceof JDBCException && (dae = this.jdbcExceptionTranslator.translate("Hibernate operation: " + (jdbcEx = (JDBCException)exToCheck).getMessage(), jdbcEx.getSQL(), jdbcEx.getSQLException())) != null) {
            return dae;
        }
        if (this.transactionExceptionTranslator != null && exToCheck instanceof TransactionException && (dae = ex.getCause()) instanceof SQLException) {
            SQLException sqlEx = (SQLException)dae;
            dae = this.transactionExceptionTranslator.translate("Hibernate transaction: " + ex.getMessage(), null, sqlEx);
            if (dae != null) {
                return dae;
            }
        }
        if (exToCheck instanceof JDBCConnectionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (exToCheck instanceof SQLGrammarException) {
            hibEx = (SQLGrammarException)exToCheck;
            return new InvalidDataAccessResourceUsageException(ex.getMessage() + "; SQL [" + hibEx.getSQL() + "]", (Throwable)ex);
        }
        if (exToCheck instanceof org.hibernate.QueryTimeoutException) {
            hibEx = (org.hibernate.QueryTimeoutException)exToCheck;
            return new QueryTimeoutException(ex.getMessage() + "; SQL [" + hibEx.getSQL() + "]", (Throwable)ex);
        }
        if (exToCheck instanceof LockAcquisitionException) {
            hibEx = (LockAcquisitionException)exToCheck;
            return new CannotAcquireLockException(ex.getMessage() + "; SQL [" + hibEx.getSQL() + "]", (Throwable)ex);
        }
        if (exToCheck instanceof PessimisticLockException) {
            hibEx = (PessimisticLockException)exToCheck;
            return new PessimisticLockingFailureException(ex.getMessage() + "; SQL [" + hibEx.getSQL() + "]", (Throwable)ex);
        }
        if (exToCheck instanceof ConstraintViolationException) {
            hibEx = (ConstraintViolationException)exToCheck;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + hibEx.getSQL() + "]; constraint [" + hibEx.getConstraintName() + "]", (Throwable)ex);
        }
        if (exToCheck instanceof DataException) {
            hibEx = (DataException)exToCheck;
            return new DataIntegrityViolationException(ex.getMessage() + "; SQL [" + hibEx.getSQL() + "]", (Throwable)ex);
        }
        if (exToCheck instanceof QueryException) {
            return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (exToCheck instanceof NonUniqueResultException) {
            return new IncorrectResultSizeDataAccessException(ex.getMessage(), 1, (Throwable)ex);
        }
        if (exToCheck instanceof NonUniqueObjectException) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (exToCheck instanceof PropertyValueException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (exToCheck instanceof PersistentObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (exToCheck instanceof TransientObjectException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (exToCheck instanceof ObjectDeletedException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (exToCheck instanceof UnresolvableObjectException) {
            hibEx = (UnresolvableObjectException)exToCheck;
            return new ObjectRetrievalFailureException(hibEx.getEntityName(), hibEx.getIdentifier(), ex.getMessage(), (Throwable)ex);
        }
        if (exToCheck instanceof WrongClassException) {
            hibEx = (WrongClassException)exToCheck;
            return new ObjectRetrievalFailureException(hibEx.getEntityName(), hibEx.getIdentifier(), ex.getMessage(), (Throwable)ex);
        }
        if (exToCheck instanceof StaleObjectStateException) {
            hibEx = (StaleObjectStateException)exToCheck;
            return new ObjectOptimisticLockingFailureException(hibEx.getEntityName(), hibEx.getIdentifier(), ex.getMessage(), (Throwable)ex);
        }
        if (exToCheck instanceof StaleStateException) {
            return new ObjectOptimisticLockingFailureException(ex.getMessage(), ex);
        }
        if (exToCheck instanceof OptimisticEntityLockException) {
            return new ObjectOptimisticLockingFailureException(ex.getMessage(), ex);
        }
        if (exToCheck instanceof PessimisticEntityLockException) {
            if (ex.getCause() instanceof LockAcquisitionException) {
                return new CannotAcquireLockException(ex.getMessage(), ex.getCause());
            }
            return new PessimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        Throwable throwable = exToCheck.getCause();
        if (throwable instanceof HibernateException) {
            HibernateException causeToCheck = (HibernateException)throwable;
            return this.convertHibernateAccessException(ex, causeToCheck);
        }
        return new JpaSystemException((RuntimeException)((Object)ex));
    }
}

