/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.commons.logging.LogFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.transaction.SavepointManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;

public class OpenJpaDialect
extends DefaultJpaDialect {
    @Override
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        super.beginTransaction(entityManager, definition);
        OpenJPAEntityManager em = this.getOpenJPAEntityManager(entityManager);
        if (!definition.isReadOnly()) {
            em.beginStore();
        }
        return new OpenJpaTransactionData(em);
    }

    @Override
    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        return new OpenJpaConnectionHandle(this.getOpenJPAEntityManager(entityManager));
    }

    protected OpenJPAEntityManager getOpenJPAEntityManager(EntityManager em) {
        return OpenJPAPersistence.cast((EntityManager)em);
    }

    private static class OpenJpaConnectionHandle
    implements ConnectionHandle {
        private final OpenJPAEntityManager entityManager;

        public OpenJpaConnectionHandle(OpenJPAEntityManager entityManager) {
            this.entityManager = entityManager;
        }

        public Connection getConnection() {
            return (Connection)this.entityManager.getConnection();
        }

        public void releaseConnection(Connection con) {
            JdbcUtils.closeConnection((Connection)con);
        }
    }

    private static class OpenJpaTransactionData
    implements SavepointManager {
        private final OpenJPAEntityManager entityManager;
        private int savepointCounter = 0;

        public OpenJpaTransactionData(OpenJPAEntityManager entityManager) {
            this.entityManager = entityManager;
        }

        public Object createSavepoint() throws TransactionException {
            ++this.savepointCounter;
            String savepointName = "SAVEPOINT_" + this.savepointCounter;
            this.entityManager.setSavepoint(savepointName);
            return savepointName;
        }

        public void rollbackToSavepoint(Object savepoint) throws TransactionException {
            this.entityManager.rollbackToSavepoint((String)savepoint);
        }

        public void releaseSavepoint(Object savepoint) throws TransactionException {
            try {
                this.entityManager.releaseSavepoint((String)savepoint);
            }
            catch (Throwable ex) {
                LogFactory.getLog(OpenJpaTransactionData.class).debug((Object)"Could not explicitly release OpenJPA savepoint", ex);
            }
        }
    }
}

