/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.converter;

import com.fasterxml.jackson.annotation.JsonView;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;

public class JacksonJsonMessageConverter
extends AbstractMessageConverter {
    private static final MimeType[] DEFAULT_MIME_TYPES = new MimeType[]{new MimeType("application", "json"), new MimeType("application", "*+json")};
    private final ObjectMapper objectMapper;

    public JacksonJsonMessageConverter() {
        this(DEFAULT_MIME_TYPES);
    }

    public JacksonJsonMessageConverter(MimeType ... supportedMimeTypes) {
        super(supportedMimeTypes);
        this.objectMapper = ((JsonMapper.Builder)JsonMapper.builder().findAndAddModules(JacksonJsonMessageConverter.class.getClassLoader())).build();
    }

    public JacksonJsonMessageConverter(ObjectMapper objectMapper) {
        this(objectMapper, DEFAULT_MIME_TYPES);
    }

    public JacksonJsonMessageConverter(ObjectMapper objectMapper, MimeType ... supportedMimeTypes) {
        super(supportedMimeTypes);
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    @Override
    protected boolean canConvertFrom(Message<?> message, @Nullable Class<?> targetClass) {
        return targetClass != null && this.supportsMimeType(message.getHeaders());
    }

    @Override
    protected boolean canConvertTo(Object payload, @Nullable MessageHeaders headers) {
        return this.supportsMimeType(headers);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected @Nullable Object convertFromInternal(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        JavaType javaType = this.objectMapper.constructType(JacksonJsonMessageConverter.getResolvedType(targetClass, conversionHint));
        Object payload = message.getPayload();
        Class<?> view = this.getSerializationView(conversionHint);
        try {
            if (ClassUtils.isAssignableValue(targetClass, payload)) {
                return payload;
            }
            if (payload instanceof byte[]) {
                byte[] bytes = (byte[])payload;
                if (view != null) {
                    return this.objectMapper.readerWithView(view).forType(javaType).readValue(bytes);
                }
                return this.objectMapper.readValue(bytes, javaType);
            }
            if (view != null) {
                return this.objectMapper.readerWithView(view).forType(javaType).readValue(payload.toString());
            }
            return this.objectMapper.readValue(payload.toString(), javaType);
        }
        catch (JacksonException ex) {
            throw new MessageConversionException(message, "Could not read JSON: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected @Nullable Object convertToInternal(Object payload, @Nullable MessageHeaders headers, @Nullable Object conversionHint) {
        block13: {
            try {
                Class<?> view = this.getSerializationView(conversionHint);
                if (byte[].class == this.getSerializedPayloadClass()) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                    JsonEncoding encoding = this.getJsonEncoding(this.getMimeType(headers));
                    try (JsonGenerator generator = this.objectMapper.createGenerator((OutputStream)out, encoding);){
                        if (view != null) {
                            this.objectMapper.writerWithView(view).writeValue(generator, payload);
                        } else {
                            this.objectMapper.writeValue(generator, payload);
                        }
                        payload = out.toByteArray();
                        break block13;
                    }
                }
                StringWriter writer = new StringWriter(1024);
                if (view != null) {
                    this.objectMapper.writerWithView(view).writeValue((Writer)writer, payload);
                } else {
                    this.objectMapper.writeValue((Writer)writer, payload);
                }
                payload = ((Object)writer).toString();
            }
            catch (JacksonException ex) {
                throw new MessageConversionException("Could not write JSON: " + ex.getMessage(), (Throwable)ex);
            }
        }
        return payload;
    }

    protected @Nullable Class<?> getSerializationView(@Nullable Object conversionHint) {
        if (conversionHint instanceof MethodParameter) {
            JsonView annotation;
            MethodParameter param = (MethodParameter)conversionHint;
            JsonView jsonView = annotation = param.getParameterIndex() >= 0 ? (JsonView)param.getParameterAnnotation(JsonView.class) : (JsonView)param.getMethodAnnotation(JsonView.class);
            if (annotation != null) {
                return this.extractViewClass(annotation, conversionHint);
            }
        } else {
            if (conversionHint instanceof JsonView) {
                JsonView jsonView = (JsonView)conversionHint;
                return this.extractViewClass(jsonView, conversionHint);
            }
            if (conversionHint instanceof Class) {
                Class clazz = (Class)conversionHint;
                return clazz;
            }
        }
        return null;
    }

    private Class<?> extractViewClass(JsonView annotation, Object conversionHint) {
        Class[] classes = annotation.value();
        if (classes.length != 1) {
            throw new IllegalArgumentException("@JsonView only supported for handler methods with exactly 1 class argument: " + String.valueOf(conversionHint));
        }
        return classes[0];
    }

    protected JsonEncoding getJsonEncoding(@Nullable MimeType contentType) {
        if (contentType != null && contentType.getCharset() != null) {
            Charset charset = contentType.getCharset();
            for (JsonEncoding encoding : JsonEncoding.values()) {
                if (!charset.name().equals(encoding.getJavaName())) continue;
                return encoding;
            }
        }
        return JsonEncoding.UTF8;
    }
}

