/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import javax.persistence.EntityManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.orm.jpa.JpaAccessor;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JpaInterceptor
extends JpaAccessor
implements MethodInterceptor {
    private boolean exceptionConversionEnabled = true;

    public void setExceptionConversionEnabled(boolean exceptionConversionEnabled) {
        this.exceptionConversionEnabled = exceptionConversionEnabled;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        EntityManager em = this.getTransactionalEntityManager();
        boolean isNewEm = false;
        if (em == null) {
            this.logger.debug((Object)"Creating new EntityManager for JpaInterceptor invocation");
            em = this.createEntityManager();
            isNewEm = true;
            TransactionSynchronizationManager.bindResource((Object)this.getEntityManagerFactory(), (Object)((Object)new EntityManagerHolder(em)));
        }
        try {
            Object retVal = methodInvocation.proceed();
            this.flushIfNecessary(em, !isNewEm);
            Object object = retVal;
            return object;
        }
        catch (RuntimeException rawException) {
            if (this.exceptionConversionEnabled) {
                throw this.translateIfNecessary(rawException);
            }
            throw rawException;
        }
        finally {
            if (isNewEm) {
                TransactionSynchronizationManager.unbindResource((Object)this.getEntityManagerFactory());
                this.logger.debug((Object)"Closing new EntityManager after JpaInterceptor invocation");
                em.close();
            }
        }
    }
}

