/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support;

import jakarta.jms.Destination;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.NativeMessageHeaderAccessor;

public class JmsMessageHeaderAccessor
extends NativeMessageHeaderAccessor {
    protected JmsMessageHeaderAccessor(Map<String, List<String>> nativeHeaders) {
        super(nativeHeaders);
    }

    protected JmsMessageHeaderAccessor(Message<?> message) {
        super(message);
    }

    public @Nullable String getCorrelationId() {
        return (String)this.getHeader("jms_correlationId");
    }

    public @Nullable Destination getDestination() {
        return (Destination)this.getHeader("jms_destination");
    }

    public @Nullable Integer getDeliveryMode() {
        return (Integer)this.getHeader("jms_deliveryMode");
    }

    public @Nullable Long getExpiration() {
        return (Long)this.getHeader("jms_expiration");
    }

    public @Nullable String getMessageId() {
        return (String)this.getHeader("jms_messageId");
    }

    public @Nullable Integer getPriority() {
        return (Integer)this.getHeader("jms_priority");
    }

    public @Nullable Destination getReplyTo() {
        return (Destination)this.getHeader("jms_replyTo");
    }

    public @Nullable Boolean getRedelivered() {
        return (Boolean)this.getHeader("jms_redelivered");
    }

    public @Nullable String getType() {
        return (String)this.getHeader("jms_type");
    }

    public @Nullable Long getTimestamp() {
        return (Long)this.getHeader("jms_timestamp");
    }

    public static JmsMessageHeaderAccessor wrap(Message<?> message) {
        return new JmsMessageHeaderAccessor(message);
    }
}

