/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.converter;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jms.support.JmsHeaderMapper;
import org.springframework.jms.support.SimpleJmsHeaderMapper;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.SimpleMessageConverter;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;

public class MessagingMessageConverter
implements MessageConverter,
InitializingBean {
    private MessageConverter payloadConverter;
    private JmsHeaderMapper headerMapper;

    public MessagingMessageConverter() {
        this(new SimpleMessageConverter(), new SimpleJmsHeaderMapper());
    }

    public MessagingMessageConverter(MessageConverter payloadConverter) {
        this(payloadConverter, new SimpleJmsHeaderMapper());
    }

    public MessagingMessageConverter(MessageConverter payloadConverter, JmsHeaderMapper headerMapper) {
        Assert.notNull((Object)payloadConverter, (String)"'payloadConverter' must not be null");
        Assert.notNull((Object)headerMapper, (String)"'headerMapper' must not be null");
        this.payloadConverter = payloadConverter;
        this.headerMapper = headerMapper;
    }

    public void setPayloadConverter(MessageConverter payloadConverter) {
        this.payloadConverter = payloadConverter;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.payloadConverter, (String)"Property 'payloadConverter' is required");
        Assert.notNull((Object)this.headerMapper, (String)"Property 'headerMapper' is required");
    }

    @Override
    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        if (!(object instanceof org.springframework.messaging.Message)) {
            throw new IllegalArgumentException("Could not convert [" + String.valueOf(object) + "] - only [" + org.springframework.messaging.Message.class.getName() + "] is handled by this converter");
        }
        org.springframework.messaging.Message input = (org.springframework.messaging.Message)object;
        MessageHeaders headers = input.getHeaders();
        Object conversionHint = headers.get((Object)"conversionHint");
        Message reply = this.createMessageForPayload(input.getPayload(), session, conversionHint);
        this.headerMapper.fromHeaders(headers, reply);
        return reply;
    }

    @Override
    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        MessageBuilder messageBuilder;
        MessageHeaders mappedHeaders = this.extractHeaders(message);
        Object convertedObject = this.extractPayload(message);
        if (convertedObject instanceof org.springframework.messaging.Message) {
            org.springframework.messaging.Message springMessage = (org.springframework.messaging.Message)convertedObject;
            messageBuilder = MessageBuilder.fromMessage((org.springframework.messaging.Message)springMessage);
        } else {
            messageBuilder = MessageBuilder.withPayload((Object)convertedObject);
        }
        MessageBuilder builder = messageBuilder;
        return builder.copyHeadersIfAbsent((Map)mappedHeaders).build();
    }

    protected Object extractPayload(Message message) throws JMSException {
        return this.payloadConverter.fromMessage(message);
    }

    protected Message createMessageForPayload(Object payload, Session session, @Nullable Object conversionHint) throws JMSException {
        return this.payloadConverter.toMessage(payload, session);
    }

    protected final MessageHeaders extractHeaders(Message message) {
        return this.headerMapper.toHeaders(message);
    }
}

