/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import io.micrometer.jakarta9.instrument.jms.DefaultJmsProcessObservationConvention;
import io.micrometer.jakarta9.instrument.jms.JmsInstrumentation;
import io.micrometer.jakarta9.instrument.jms.JmsObservationDocumentation;
import io.micrometer.jakarta9.instrument.jms.JmsProcessObservationContext;
import io.micrometer.jakarta9.instrument.jms.JmsProcessObservationConvention;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.jspecify.annotations.Nullable;
import org.springframework.jms.listener.AbstractJmsListeningContainer;
import org.springframework.jms.listener.MessageListenerContainer;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.listener.SubscriptionNameProvider;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.QosSettings;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ErrorHandler;

public abstract class AbstractMessageListenerContainer
extends AbstractJmsListeningContainer
implements MessageListenerContainer {
    private static final boolean micrometerJakartaPresent = ClassUtils.isPresent((String)"io.micrometer.jakarta9.instrument.jms.JmsInstrumentation", (ClassLoader)AbstractMessageListenerContainer.class.getClassLoader());
    private volatile @Nullable Object destination;
    private volatile @Nullable String messageSelector;
    private volatile @Nullable Object messageListener;
    private boolean subscriptionDurable = false;
    private boolean subscriptionShared = false;
    private @Nullable String subscriptionName;
    private boolean pubSubNoLocal = false;
    private @Nullable Boolean replyPubSubDomain;
    private @Nullable QosSettings replyQosSettings;
    private @Nullable MessageConverter messageConverter;
    private @Nullable ExceptionListener exceptionListener;
    private @Nullable ErrorHandler errorHandler;
    private @Nullable ObservationRegistry observationRegistry;
    private boolean acknowledgeAfterListener = true;
    private boolean exposeListenerSession = true;
    private boolean acceptMessagesWhileStopping = false;

    public abstract void setConcurrency(String var1);

    public void setDestination(@Nullable Destination destination) {
        this.destination = destination;
        if (destination instanceof Topic && !(destination instanceof Queue)) {
            this.setPubSubDomain(true);
        }
    }

    public @Nullable Destination getDestination() {
        Destination _destination;
        Object object = this.destination;
        return object instanceof Destination ? (_destination = (Destination)object) : null;
    }

    public void setDestinationName(@Nullable String destinationName) {
        this.destination = destinationName;
    }

    public @Nullable String getDestinationName() {
        String name;
        Object object = this.destination;
        return object instanceof String ? (name = (String)object) : null;
    }

    protected String getDestinationDescription() {
        Object destination = this.destination;
        return destination != null ? destination.toString() : "";
    }

    public void setMessageSelector(@Nullable String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public @Nullable String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageListener(@Nullable Object messageListener) {
        this.checkMessageListener(messageListener);
        this.messageListener = messageListener;
        if (messageListener != null && this.subscriptionName == null) {
            this.subscriptionName = this.getDefaultSubscriptionName(messageListener);
        }
    }

    public @Nullable Object getMessageListener() {
        return this.messageListener;
    }

    protected void checkMessageListener(@Nullable Object messageListener) {
        if (messageListener != null && !(messageListener instanceof MessageListener) && !(messageListener instanceof SessionAwareMessageListener)) {
            throw new IllegalArgumentException("Message listener needs to be of type [" + MessageListener.class.getName() + "] or [" + SessionAwareMessageListener.class.getName() + "]");
        }
    }

    protected String getDefaultSubscriptionName(Object messageListener) {
        if (messageListener instanceof SubscriptionNameProvider) {
            SubscriptionNameProvider subscriptionNameProvider = (SubscriptionNameProvider)messageListener;
            return subscriptionNameProvider.getSubscriptionName();
        }
        return messageListener.getClass().getName();
    }

    public void setSubscriptionDurable(boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
        if (subscriptionDurable) {
            this.setPubSubDomain(true);
        }
    }

    public boolean isSubscriptionDurable() {
        return this.subscriptionDurable;
    }

    public void setSubscriptionShared(boolean subscriptionShared) {
        this.subscriptionShared = subscriptionShared;
        if (subscriptionShared) {
            this.setPubSubDomain(true);
        }
    }

    public boolean isSubscriptionShared() {
        return this.subscriptionShared;
    }

    public void setSubscriptionName(@Nullable String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public @Nullable String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setDurableSubscriptionName(@Nullable String durableSubscriptionName) {
        this.subscriptionName = durableSubscriptionName;
        this.subscriptionDurable = durableSubscriptionName != null;
    }

    public @Nullable String getDurableSubscriptionName() {
        return this.subscriptionDurable ? this.subscriptionName : null;
    }

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    public boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setReplyPubSubDomain(boolean replyPubSubDomain) {
        this.replyPubSubDomain = replyPubSubDomain;
    }

    @Override
    public boolean isReplyPubSubDomain() {
        return this.replyPubSubDomain != null ? this.replyPubSubDomain.booleanValue() : this.isPubSubDomain();
    }

    public void setReplyQosSettings(@Nullable QosSettings replyQosSettings) {
        this.replyQosSettings = replyQosSettings;
    }

    @Override
    public @Nullable QosSettings getReplyQosSettings() {
        return this.replyQosSettings;
    }

    public void setMessageConverter(@Nullable MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    @Override
    public @Nullable MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setExceptionListener(@Nullable ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public @Nullable ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void setErrorHandler(@Nullable ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public @Nullable ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setObservationRegistry(@Nullable ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    public @Nullable ObservationRegistry getObservationRegistry() {
        return this.observationRegistry;
    }

    public void setAcknowledgeAfterListener(boolean acknowledgeAfterListener) {
        this.acknowledgeAfterListener = acknowledgeAfterListener;
    }

    public boolean isAcknowledgeAfterListener() {
        return this.acknowledgeAfterListener;
    }

    public void setExposeListenerSession(boolean exposeListenerSession) {
        this.exposeListenerSession = exposeListenerSession;
    }

    public boolean isExposeListenerSession() {
        return this.exposeListenerSession;
    }

    public void setAcceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
        this.acceptMessagesWhileStopping = acceptMessagesWhileStopping;
    }

    public boolean isAcceptMessagesWhileStopping() {
        return this.acceptMessagesWhileStopping;
    }

    @Override
    protected void validateConfiguration() {
        if (this.destination == null) {
            throw new IllegalArgumentException("Property 'destination' or 'destinationName' is required");
        }
    }

    @Override
    public void setupMessageListener(Object messageListener) {
        this.setMessageListener(messageListener);
    }

    protected void executeListener(Session session, Message message) {
        try {
            this.doExecuteListener(session, message);
        }
        catch (Throwable ex) {
            this.handleListenerException(ex);
        }
    }

    protected Observation createObservation(Message message) {
        if (micrometerJakartaPresent && this.observationRegistry != null) {
            return ObservationFactory.create(this.observationRegistry, message);
        }
        return Observation.NOOP;
    }

    protected void doExecuteListener(Session session, Message message) throws JMSException {
        if (!this.isAcceptMessagesWhileStopping() && !this.isRunning()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Rejecting received message because of the listener container having been stopped in the meantime: " + String.valueOf(message)));
            }
            this.rollbackIfNecessary(session);
            throw new MessageRejectedWhileStoppingException();
        }
        try {
            this.invokeListener(session, message);
        }
        catch (JMSException | Error | RuntimeException ex) {
            this.rollbackOnExceptionIfNecessary(session, ex);
            throw ex;
        }
        this.commitIfNecessary(session, message);
    }

    protected void invokeListener(Session session, Message message) throws JMSException {
        Object listener = this.getMessageListener();
        if (listener instanceof SessionAwareMessageListener) {
            SessionAwareMessageListener sessionAwareMessageListener = (SessionAwareMessageListener)listener;
            this.doInvokeListener(sessionAwareMessageListener, session, message);
        } else if (listener instanceof MessageListener) {
            MessageListener msgListener = (MessageListener)listener;
            this.doInvokeListener(msgListener, message);
        } else {
            if (listener != null) {
                throw new IllegalArgumentException("Only MessageListener and SessionAwareMessageListener supported: " + String.valueOf(listener));
            }
            throw new IllegalStateException("No message listener specified - see property 'messageListener'");
        }
    }

    protected void doInvokeListener(SessionAwareMessageListener listener, Session session, Message message) throws JMSException {
        Connection conToClose = null;
        Session sessionToClose = null;
        try {
            Session sessionToUse = session;
            if (micrometerJakartaPresent && this.observationRegistry != null) {
                sessionToUse = MicrometerInstrumentation.instrumentSession(sessionToUse, this.observationRegistry);
            }
            if (!this.isExposeListenerSession()) {
                conToClose = this.createConnection();
                sessionToUse = sessionToClose = this.createSession(conToClose);
            }
            listener.onMessage(message, sessionToUse);
            if (sessionToUse != session && sessionToUse.getTransacted() && this.isSessionLocallyTransacted(sessionToUse)) {
                JmsUtils.commitIfNecessary(sessionToUse);
            }
        }
        catch (JMSException exc) {
            try {
                throw exc;
            }
            catch (Throwable throwable) {
                JmsUtils.closeSession(sessionToClose);
                JmsUtils.closeConnection(conToClose);
                throw throwable;
            }
        }
        JmsUtils.closeSession(sessionToClose);
        JmsUtils.closeConnection(conToClose);
    }

    protected void doInvokeListener(MessageListener listener, Message message) throws JMSException {
        listener.onMessage(message);
    }

    protected void commitIfNecessary(Session session, @Nullable Message message) throws JMSException {
        if (session.getTransacted()) {
            if (this.isSessionLocallyTransacted(session)) {
                JmsUtils.commitIfNecessary(session);
            }
        } else if (message != null && this.isAcknowledgeAfterListener() && this.isClientAcknowledge(session)) {
            message.acknowledge();
        }
    }

    protected void rollbackIfNecessary(Session session) throws JMSException {
        if (session.getTransacted()) {
            if (this.isSessionLocallyTransacted(session)) {
                JmsUtils.rollbackIfNecessary(session);
            }
        } else if (this.isClientAcknowledge(session)) {
            session.recover();
        }
    }

    protected void rollbackOnExceptionIfNecessary(Session session, Throwable ex) throws JMSException {
        try {
            if (session.getTransacted()) {
                if (this.isSessionLocallyTransacted(session)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"Initiating transaction rollback on application exception", ex);
                    }
                    JmsUtils.rollbackIfNecessary(session);
                }
            } else if (this.isClientAcknowledge(session)) {
                session.recover();
            }
        }
        catch (IllegalStateException ex2) {
            this.logger.debug((Object)"Could not roll back because Session already closed", (Throwable)ex2);
        }
        catch (JMSException | Error | RuntimeException ex2) {
            this.logger.error((Object)"Application exception overridden by rollback error", ex);
            throw ex2;
        }
    }

    protected boolean isSessionLocallyTransacted(Session session) {
        return this.isSessionTransacted();
    }

    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (this.isPubSubDomain() && destination instanceof Topic) {
            Topic topic = (Topic)destination;
            if (this.isSubscriptionShared()) {
                return this.isSubscriptionDurable() ? session.createSharedDurableConsumer(topic, this.getSubscriptionName(), this.getMessageSelector()) : session.createSharedConsumer(topic, this.getSubscriptionName(), this.getMessageSelector());
            }
            if (this.isSubscriptionDurable()) {
                return session.createDurableSubscriber(topic, this.getSubscriptionName(), this.getMessageSelector(), this.isPubSubNoLocal());
            }
            return session.createConsumer(destination, this.getMessageSelector(), this.isPubSubNoLocal());
        }
        return session.createConsumer(destination, this.getMessageSelector());
    }

    protected void handleListenerException(Throwable ex) {
        if (ex instanceof MessageRejectedWhileStoppingException) {
            return;
        }
        if (ex instanceof JMSException) {
            JMSException jmsException = (JMSException)ex;
            this.invokeExceptionListener(jmsException);
        }
        if (this.isActive()) {
            this.invokeErrorHandler(ex);
        } else {
            this.logger.debug((Object)"Listener exception after container shutdown", ex);
        }
    }

    protected void invokeExceptionListener(JMSException ex) {
        ExceptionListener exceptionListener = this.getExceptionListener();
        if (exceptionListener != null) {
            exceptionListener.onException(ex);
        }
    }

    protected void invokeErrorHandler(Throwable ex) {
        ErrorHandler errorHandler = this.getErrorHandler();
        if (errorHandler != null) {
            errorHandler.handleError(ex);
        } else {
            this.logger.warn((Object)"Execution of JMS message listener failed, and no ErrorHandler has been set.", ex);
        }
    }

    private static abstract class ObservationFactory {
        private static final JmsProcessObservationConvention DEFAULT_CONVENTION = new DefaultJmsProcessObservationConvention();

        private ObservationFactory() {
        }

        static Observation create(ObservationRegistry registry, Message message) {
            return JmsObservationDocumentation.JMS_MESSAGE_PROCESS.observation(null, (ObservationConvention)DEFAULT_CONVENTION, () -> new JmsProcessObservationContext(message), registry);
        }
    }

    private static class MessageRejectedWhileStoppingException
    extends RuntimeException {
        private MessageRejectedWhileStoppingException() {
        }
    }

    private static abstract class MicrometerInstrumentation {
        private MicrometerInstrumentation() {
        }

        static Session instrumentSession(Session session, ObservationRegistry registry) {
            return JmsInstrumentation.instrumentSession((Session)session, (ObservationRegistry)registry);
        }
    }
}

